/*
 * @R3_COPYRIGHT@
 */

package JP.ac.keio.sfc.ht.mogul.system;

import JP.ac.keio.sfc.ht.mogul.mogulet.*;
import JP.ac.keio.sfc.ht.mogul.event.*;
//import JP.ac.keio.sfc.ht.mogul.security.*;
import java.awt.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import java.rmi.server.*;

public class UserManager extends UnicastRemoteObject implements RemoteUserManager, Runnable{
  private EnvironmentManager emanager;
  private String hostname;
  private String username;
  private Hashtable table;
  private Hashtable counter;

  public UserManager() throws Exception {
    emanager = new EnvironmentManager();
  }

  public UserManager(String host, String user) throws Exception {
    emanager = new EnvironmentManager();
    hostname = host;
    username = user;

    tableInit();
    setID(new Identifier(host, user, null, null));
  }

  private void tableInit(){
    table = new Hashtable();
    counter = new Hashtable();
  }

  public Identifier[] list(Identifier id) throws RemoteException {
    System.err.println("["+id+"]");
    if(isMyself(id)){
      Identifier ids[] = new Identifier[table.size()];
      Enumeration keys = table.keys();
      try{
	for(int i=0; keys.hasMoreElements(); i++)
	  ids[i] = new Identifier((String)keys.nextElement());
      }catch(Exception e){
	//ERRORs must not be brought
      }

      return ids;
    }
    else{
      //[g}l[Wɐڑ
      //[g}l[Wlist\bh
      try{
	RemoteUserManager manager = connect(id);
	return manager.list(id);
      }catch(Exception e){
	e.printStackTrace();
	throw new RemoteException(e.toString());
      }
    }
  }

  public void copy(Mogulet m, Identifier to, Identifier from)
    throws RemoteException {
      if(!to.isUserManager())
	return;

      if(from == null){
	//l
	//[g}l[Wɐڑ
	//[g}l[Wɕړ
	try{
	  RemoteUserManager manager = connect(to);
	  manager.copy(m, to, getID());
	}catch(Exception e){
	  e.printStackTrace();
	  throw new RemoteException(e.toString());
	}
      }
      else{
	//
	System.err.println("got [" + m + "] from " + from);
	m.mogulReset();

	if(m instanceof Container){
	  Component[] c = ((Container)m).getComponents();
	  for(int i=0; i < c.length; i++){
	    if(c[i] instanceof Mogulet)
	      ((Mogulet)c[i]).mogulReset();
	    if(c[i] instanceof EnvironmentEventListener)
	      ((EnvironmentEventListener)c[i]).environmentChanged(new EnvironmentEvent(emanager));
	  }
	}

	if(m instanceof Frame)
	  ((Frame)m).show();
	if(m instanceof EnvironmentEventListener)
	  ((EnvironmentEventListener)m).environmentChanged(new EnvironmentEvent(emanager));
      }
    }
  
  public void move(Mogulet m, Identifier to, Identifier from)
    throws RemoteException {
      if(!to.isUserManager())
	return;
      
      if(from == null){
	//l
	//[g}l[Wɐڑ
	//[g}l[Wɕړ
	//[J̎ʎq폜
	try{
	  System.err.println("moving [" + m + "] to " + to);
	  RemoteUserManager manager = connect(to);
	  manager.move(m, to, getID());
	  table.remove(m);
	}catch(Exception e){
	  e.printStackTrace();
	  throw new RemoteException(e.toString());
	}
      }
      else{
	//
	System.err.println("got [" + m + "] from " + from);
	m.mogulReset();
	
	if(m instanceof Container){
	  Component[] c = ((Container)m).getComponents();
	  for(int i=0; i < c.length; i++){
	    if(c[i] instanceof Mogulet)
	      ((Mogulet)c[i]).mogulReset();
	    if(c[i] instanceof EnvironmentEventListener)
	      ((EnvironmentEventListener)c[i]).environmentChanged(new EnvironmentEvent(emanager));
	  }
	}
	
	if(m instanceof Frame)
	  ((Frame)m).show();
	if(m instanceof EnvironmentEventListener)
	  ((EnvironmentEventListener)m).environmentChanged(new EnvironmentEvent(emanager));
      }
    }
  
  public void delete(Identifier target,Identifier from) throws RemoteException {
    Identifier mid;
    try{
      mid = target.forManagerID();
    }catch(MalformedIdentifierException e){
      throw new RemoteException("cannot resolve manager ID");
    }
    
    if(mid.toString().equals(getID().toString())){
      if(table.containsKey(target.toString())){
	try{
	  deleteIdentifier(target.toString());
	}catch(Exception e){
	  e.printStackTrace();
	  throw new RemoteException(e.toString());
	}
      }
      else
	throw new RemoteException("no such object: " + target);
    }
    else{
      try{
	//[g}l[Wɐڑ
	RemoteUserManager manager = connect(mid);
	//[g}l[Wdelete\bh
	manager.delete(target, getID());
      }catch(Exception e){
	e.printStackTrace();
	throw new RemoteException(e.toString());
      }
    }
  }
  
  public Identifier create(Mogulet m) throws RemoteException {
    Identifier id = null;
    try{
      id = createIdentifier(m.getClass().getName());
      table.put(id.toString(), m);
    }catch(MalformedIdentifierException e){
      e.printStackTrace();
      throw new RemoteException(e.toString());
    }
    
    return id;
  }
  
  private void deleteIdentifier(String id)
    throws Exception 
      {
	//[J̎ʎq폜
	table.remove(id);
	Naming.unbind(id);
      }
  
  private Identifier createIdentifier(String classname)
    throws MalformedIdentifierException, RemoteException 
      {
	/** NEEDED MORE CONSIDERATION **/
	/** ʒuߓIȎʎq **/
	Integer i = (Integer)counter.get(classname);
	if(i == null)
	  i = new Integer(0);
	
	counter.remove(classname);
	counter.put(classname, new Integer(i.intValue() + 1));
	
	return new Identifier("//" + hostname + "/" + username + "/" + classname + "/" + i.toString());
      }
  
  private RemoteUserManager connect(Identifier id) throws Exception {
    return (RemoteUserManager)Naming.lookup(id.toString());
  }
  
  public void run(){
    try{
      UserManager.main(null);
    }catch(Exception e){
      e.printStackTrace();
    }
  }
  
  public static void main(String argv[]) throws Exception {
    //System.setSecurityManager(new RMISecurityManager());
    //System.setSecurityManager(new MogulSecurityManager());
    
    String hostname = null;
    String username = System.getProperty("user.name");
    
    //if(argv.length == 1)
    //hostname = InetAddress.getByName(argv[0]).getHostAddress();
    //else
    hostname = InetAddress.getLocalHost().getHostAddress();
    
    UserManager manager = new UserManager(hostname, username);
    System.err.println("["+manager.getID()+"]");
    Naming.bind(manager.getID().toString(), manager);
  }
  
  protected Identifier ID;
  
  public Identifier getID() throws RemoteException{
    return ID;
  }
  
  protected void setID(Identifier id){
    ID = id;
  }
  
  protected boolean isMyself(Identifier id) {
    try{
      InetAddress addr[] = InetAddress.getAllByName(id.getHostname());
      
      for(int i=0; i < addr.length; i++){
	String ip = addr[i].getHostAddress();
	if((ip.compareTo(hostname) == 0 || ip.compareTo("127.0.0.1") == 0) 
	   && id.getUsername().compareTo(username) == 0){
	  return true;
	}
      }
      
      return false;
    }catch(Exception e){
      e.printStackTrace();
      return false;
    }
  }
}
