/*
 * @R3_COPYRIGHT@
 */

package JP.ac.keio.sfc.ht.mogul.system;

import java.util.StringTokenizer;
import java.io.Serializable;

public class Identifier implements Serializable{
  protected String proto;
  protected String id;
  protected String host, user, clss, number;

  public Identifier(String str)
    throws MalformedIdentifierException 
      {
	StringTokenizer st = new StringTokenizer(str, ":/");

	try{
	  if(!str.startsWith("//"))
	    proto = st.nextToken();
	  else
	    proto = "rmi";

	  host = st.nextToken();
	  user = st.nextToken();
	}catch(Exception e1){
	  throw new MalformedIdentifierException(e1.toString());
	}

	try{
	  clss = st.nextToken();
	}catch(Exception e2){
	  clss = null;
	}
	try{
	  number = st.nextToken();
	}catch(Exception e2){
	  number = null;
	}

	if(host == null)
	  throw new MalformedIdentifierException("invalid hostname: null");
	else if(user == null)
	  throw new MalformedIdentifierException("invalid username: null");
	
	id = new String(proto+"://"+host+"/"+user);

	if(clss != null)
	  id = id + "/" + clss;

	if(number != null)
	  id = id + "/" + number;
      }

  public Identifier(String h, String u, String c, String n)
    throws MalformedIdentifierException
      {
	proto = "rmi"; host = h; user = u; clss = c; number = n;
	
	if(host == null)
	  throw new MalformedIdentifierException("invalid hostname: null");
	else if(user == null)
	  throw new MalformedIdentifierException("invalid username: null");
	
	id = new String(proto+"://"+host+"/"+user);

	if(clss != null)
	  id = id + "/" + clss;

	if(number != null)
	  id = id + "/" + number;
      }

  public Identifier(String p, String h, String u, String c, String n)
    throws MalformedIdentifierException
      {
	proto = p; host = h; user = u; clss = c; number = n;
	
	if(host == null)
	  throw new MalformedIdentifierException("invalid hostname: null");
	else if(user == null)
	  throw new MalformedIdentifierException("invalid username: null");
	
	id = new String(proto+"://"+host+"/"+user);

	if(clss != null)
	  id = id + "/" + clss;

	if(number != null)
	  id = id + "/" + number;
      }

  public Identifier forManagerID() throws MalformedIdentifierException {
    return new Identifier(host, user, null, null);
  }

  public String getProtocolname(){
    return proto;
  }

  public String getHostname(){
    return host;
  }

  public String getUsername(){
    return user;
  }

  public String getClassname(){
    return clss;
  }

  public String getNumber(){
    return number;
  }

  public boolean isMogulet(){
    return (host!=null) && (user!=null) && (clss!=null) && (number != null);
  }

  public boolean isUserManager(){
    return (host != null) && (user != null) && (clss == null) && (number == null);
  }

  public boolean isSystemManager(){
    return (host != null) && (user == null) && (clss == null) && (number == null);
  }

  public String toString(){
    return id;
  }
}


