/*
 * @R3_COPYRIGHT@
 */

package JP.ac.keio.sfc.ht.mogul.mogulet;

import JP.ac.keio.sfc.ht.mogul.system.*;
import java.awt.*;
import java.util.*;
import java.rmi.*;
import java.rmi.server.*;

public class MoguletStub extends UnicastRemoteObject implements RemoteMogulet{
  private static Hashtable stub_table = null;
  private Mogulet mog;
  private Identifier ID;

  static{
    stub_table = new Hashtable();
  }

  public MoguletStub(Mogulet m) throws RemoteException {
    mog = m;

    try{
      String usrname = System.getProperty("user.name");
      RemoteUserManager manager = connect("localhost", usrname);

      ID = manager.create(mog);
      Naming.bind(ID.toString(), this);
      registerStub(mog, this);
      System.out.println("ID is set:" + ID);
    }catch(Exception e){
      e.printStackTrace();
    }
  }
  
  private static void registerStub(Mogulet m, MoguletStub stub){
    if(!stub_table.containsKey(m))
      stub_table.put(m, stub);
  }

  private static void unregisterStub(Mogulet m){
    if(stub_table.containsKey(m))
      stub_table.remove(m);
  }

  public static MoguletStub getMoguletStub(Mogulet m){
    return (MoguletStub)stub_table.get(m);
  }

  private String getClassName(){
    if(mog != null)
      return mog.getClass().getName();
    else
      return null;
  }

  private RemoteUserManager connect(String hostname, String usrname)
    throws Exception {
      Identifier mid = new Identifier("//" + hostname + "/" + usrname);
      return (RemoteUserManager)Naming.lookup(mid.toString());
    }

  public Identifier getID() throws RemoteException{
    return ID;
  }

  public void move(Identifier id) throws RemoteException{
    try{
      /**
      String usrname = System.getProperty("user.name");
      RemoteUserManager manager = connect("localhost", usrname);
      manager.move(mog, id, null);
      unregisterStub(mog);
      **/
      copy(id);

      if(mog instanceof Window)
	((Window)mog).dispose();

      delete();
    }catch(Exception e){
      throw new RemoteException(e.toString());
    }
  }
  
  public void copy(Identifier id) throws RemoteException{
    try{
      String usrname = System.getProperty("user.name");
      RemoteUserManager manager = connect("localhost", usrname);
      manager.copy(mog, id, null);
    }catch(Exception e){
      throw new RemoteException(e.toString());
    }
  }

  public void delete() throws RemoteException{
    try{
      String usrname = System.getProperty("user.name");
      RemoteUserManager manager = connect("localhost", usrname);
      manager.delete(ID, null);
      ID = null;
      unregisterStub(mog);

      if(mog instanceof Container){
	Component c[] = ((Container)mog).getComponents();
	for(int i=0; i < c.length; i++){
	  if(c[i] instanceof Mogulet)
	    ((Mogulet)c[i]).delete();
	}
      }
    }catch(Exception e){
      throw new RemoteException(e.toString());
    }
  }

  public Mogulet getMogulet() throws RemoteException {
    return mog;
  }
}
