/*
    This class is a simple extention of Canvas that runs as it's own
    thread.  It runs a simple animation.
 */

import java.awt.*;
import java.util.Random;

class ResultView extends Canvas implements Runnable
{
    private Thread  myThread;
    private int    delay = 100;
                    
  int neurons = 100;
  //10,77,100,25
  double kf=0.26;//0.2//0.1//0.17
  double kr=0.70;//0.9//1.0//0.90//
  double alpha=6.9;//10.0//10.0//9.0
  double ai=1.7;//2.0//3.2//2.3
  double epsilon=0.015;
  
    double W = 0;
    double N[] = new double[neurons];
    double N2[] = new double[neurons];
    double N3[] = new double[neurons];
    double L[] = new double[neurons];
    double L2[] = new double[neurons];
    double L3[] = new double[neurons];
    double w[][] = new double[neurons][neurons];
    double w2[][] = new double[neurons][neurons];
    double w3[][] = new double[neurons][neurons];
    double feedback=0.7;
    double gaibuin=1-feedback;
    int patterns = 3;
    int i;
    int j;
    int times = 400;
    int indentX = 0;
    int indentY = 0;
    int tmp;
    int gosa[] = new int[3];
    int gosa2[] = new int[3];
    int gosa3[] = new int[3];
    int check[] = new int[3];
    int p;
    int signal = 0;
    int signalratio = 0;
    int input_check[] = {1,0,0};
    int defpat001,defpat002,defpat010,defpat012,defpat020,defpat021;
    int defpat101,defpat102,defpat110,defpat112,defpat120,defpat121;
    int defpat201,defpat202,defpat210,defpat212,defpat220,defpat221;
    int pat00x,pat00y,pat01x,pat01y,pat02x,pat02y;
    int pat10x,pat10y,pat11x,pat11y,pat12x,pat12y;
    int pat20x,pat20y,pat21x,pat21y,pat22x,pat22y;
    int d00,d01,d02,d10,d11,d12,d20,d21,d22;
    int dy0,dy1,dy2,dx0,dx1,dx2,dy0o,dy1o,dy2o,dx0o,dx1o,dx2o=0;
    int z;
    int clearFlag=0;
    Random aRandom = new Random();

    //data

    //default input data
    double x[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    double x2[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    double x3[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    double in[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    double in2[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    double in3[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    double mixpat[]={1,1,1,1,1,1,1,1,1,1,
	1,0,0,1,1,1,1,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,1,1,1,1,0,0,1,
	1,1,1,1,1,1,1,1,1,1};

    //patterns
    int pat[][]=
  {{1,1,0,0,0,0,0,0,1,1,
	1,1,1,0,0,0,0,1,1,1,
	0,1,1,1,0,0,1,1,1,0,
	0,0,1,1,1,1,1,1,0,0,
	0,0,0,1,1,1,0,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,1,1,1,1,1,1,0,0,
	0,1,1,1,0,0,1,1,1,0,
	1,1,1,0,0,0,0,1,1,1,
	1,1,0,0,0,0,0,0,1,1},

	{0,0,0,0,0,1,0,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,0,1,1,1,1,1,0,0,
	0,0,0,1,1,0,1,1,0,0,
	0,0,1,1,1,0,1,1,1,0,
	0,0,1,1,0,0,0,1,1,0,
	0,1,1,1,0,0,0,1,1,1,
	0,1,1,1,1,1,1,1,1,1,
	0,1,1,1,1,1,1,1,1,1},

	{0,0,1,1,1,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,1,
	1,1,1,0,1,1,1,1,0,0,
	1,1,0,0,0,1,1,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,1,1,0,0,0,1,1,
	0,0,1,1,1,1,0,1,1,1,
	1,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,1,1,1,0,0,
    0,0,0,0,0,0,0,0,0,0}};

    int pat2[][]=
/*
	{{0,0,0,0,0,0,0,0,0,0,
	  1,1,1,0,0,0,0,1,1,1,
	  0,1,1,1,0,0,0,1,1,1,
	  0,0,1,1,0,0,1,1,1,0,
	  0,0,1,1,1,0,1,1,1,0,
	  0,0,0,1,1,1,1,1,0,0,
	  0,0,0,1,1,1,1,1,0,0,
	  0,0,0,1,1,1,1,0,0,0,
	  0,0,0,0,1,1,0,0,0,0,
	  0,0,0,0,1,1,0,0,0,0},
	 
	 {0,0,0,0,0,0,0,0,0,0,
	  0,0,0,0,0,0,0,0,0,0,
	  0,0,0,0,0,0,0,0,0,0,
	  1,1,1,0,0,0,0,1,1,1,
	  1,1,1,1,1,1,1,1,1,1,
	  1,1,1,1,1,1,1,1,1,1,
	  1,1,1,0,0,0,0,1,1,1,
	  0,0,0,0,0,0,0,0,0,0,
	  0,0,0,0,0,0,0,0,0,0,
	  0,0,0,0,0,0,0,0,0,0},
	  
	 {0,0,0,1,1,1,1,0,0,0,
	  0,0,0,1,1,1,1,0,0,0,
	  0,0,0,1,1,1,1,0,0,0,
	  0,0,0,0,1,1,0,0,0,0,
	  0,0,0,0,1,1,0,0,0,0,
	  0,0,0,0,1,1,0,0,0,0,
	  0,0,0,0,1,1,0,0,0,0,
	  0,0,0,1,1,1,1,0,0,0,
	  0,0,0,1,1,1,1,0,0,0,
	  0,0,0,1,1,1,1,0,0,0}};
*/
    {{1,1,0,0,0,0,0,0,1,1,
	1,1,1,0,0,0,0,1,1,1,
	0,1,1,1,0,0,1,1,1,0,
	0,0,1,1,1,1,1,1,0,0,
	0,0,0,1,1,1,0,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,1,1,1,1,1,1,0,0,
	0,1,1,1,0,0,1,1,1,0,
	1,1,1,0,0,0,0,1,1,1,
	1,1,0,0,0,0,0,0,1,1},
	
	{0,0,0,0,0,1,0,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,0,1,1,1,1,1,0,0,
	0,0,0,1,1,0,1,1,0,0,
	0,0,1,1,1,0,1,1,1,0,
	0,0,1,1,0,0,0,1,1,0,
	0,1,1,1,0,0,0,1,1,1,
	0,1,1,1,1,1,1,1,1,1,
	0,1,1,1,1,1,1,1,1,1},

	{0,0,1,1,1,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,1,
	1,1,1,0,1,1,1,1,0,0,
	1,1,0,0,0,1,1,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,1,1,0,0,0,1,1,
	0,0,1,1,1,1,0,1,1,1,
	1,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,1,1,1,0,0,
          0,0,0,0,0,0,0,0,0,0}};

    int pat3[][]=	
	
	{{1,1,0,0,0,0,0,0,1,1,
	1,1,1,0,0,0,0,1,1,1,
	0,1,1,1,0,0,1,1,1,0,
	0,0,1,1,1,1,1,1,0,0,
	0,0,0,1,1,1,0,0,0,0,
	0,0,0,0,1,1,1,0,0,0,
	0,0,1,1,1,1,1,1,0,0,
	0,1,1,1,0,0,1,1,1,0,
	1,1,1,0,0,0,0,1,1,1,
	1,1,0,0,0,0,0,0,1,1},
/*
    {{1,1,0,0,0,0,0,0,0,0,
	  1,1,1,0,0,0,0,0,0,0,
	  0,1,1,1,0,0,0,0,0,0,
	  0,0,1,1,1,0,0,0,0,0,
	  0,0,0,1,1,1,0,0,0,0,
	  0,0,0,0,1,1,1,0,0,0,
	  0,0,0,0,0,1,1,1,0,0,
	  0,0,0,0,0,0,1,1,1,0,
	  0,0,0,0,0,0,0,1,1,1,
	  0,0,0,0,0,0,0,0,1,1},
*/
      {0,0,0,0,1,1,0,0,0,0,
       0,0,1,1,1,1,1,1,0,0,
       0,1,1,1,0,0,1,1,1,0,
       0,1,1,0,0,0,0,1,1,0,
       1,1,0,0,1,1,0,0,1,1,
       1,1,0,0,1,1,0,0,1,1,
       0,1,1,0,0,0,0,1,1,0,
       0,1,1,1,0,0,1,1,1,0,
       0,0,1,1,1,1,1,1,0,0,
        0,0,0,0,1,1,0,0,0,0},

      
	{0,0,1,0,0,0,0,1,0,0,
	0,0,1,1,0,0,1,1,0,0,
	0,0,1,1,1,1,1,1,0,0,
	0,0,1,1,1,1,1,1,0,0,
	0,0,1,1,1,1,1,1,0,0,
	0,1,1,1,1,1,1,1,1,0,
	1,1,1,1,1,1,1,1,1,1,
	0,0,0,1,1,1,1,0,0,0,
	0,0,0,0,1,1,0,0,0,0,
	0,0,0,0,0,1,0,0,0,0}};

    int  relation0_1[][] = {{1,2},{0,0},{2,2}};
    int  relation0_2[][] = {{1,2},{0,0},{2,2}};
    int  relation1_0[][] = {{1,1},{0,0},{0,0}};
    int  relation1_2[][] = {{0,0},{1,1},{2,2}};
    int  relation2_0[][] = {{1,1},{0,0},{0,0}};
    int  relation2_1[][] = {{0,0},{1,1},{2,2}};

    public ResultView()
    {   
        resize(420,420);

        myThread = new Thread(this);
        cleanNetworks();
        updateInput(0,99,99,0,0,0);
        calcWeight();
        GraphInit();
        myThread.start();
    }

    public ResultView(int _delay)
    {
        this();
        if(_delay < 50) delay = 50;
        else if(_delay > 300) delay = 300;
        else delay = _delay;
    }

    public void reset() {cleanNetworks();}

    public void resume() { myThread.resume(); }

    public void setDelay(int _delay){
        delay=_delay*50;
    }
    
    public void run()
    {
        while (true)
        {
            advance();
            repaint();
            try{ Thread.sleep(delay); } catch(InterruptedException e) { this.stop(); }

        }
    }

    public void stop() { myThread.suspend(); }

    public void destroy() { this.stop(); }
    
    public void updateInput(int A1, int A2, int A3, int noiseA1, int noiseA2, int noiseA3){
        for(i=0;i<neurons;i++){
            if(A1!=99){
                       in[i]=(double)pat[A1][i];    input_check[0]=1;
            }else {
                        in[i]=0; input_check[0]=0;
            }
            if(A2!=99){
                       in2[i]=(double)pat2[A2][i];    input_check[1]=1;
            }else {
                        in2[i]=0; input_check[1]=0;
            }
            if(A3!=99){
                       in3[i]=(double)pat3[A3][i];    input_check[2]=1;
            }else {
                        in3[i]=0; input_check[2]=0;
            }
      if(Math.random()>1-(double)noiseA1/100){if(in[i]==0){ in[i]=1; }else{ in[i]=0;}}
      if(Math.random()>1-(double)noiseA2/100){if(in2[i]==0){ in2[i]=1; }else{ in2[i]=0;}}
      if(Math.random()>1-(double)noiseA3/100){if(in3[i]==0){ in3[i]=1; }else{ in3[i]=0;}}
        }
        repaint();
    }
    
    public void updateChaos(int KF, int KR, int ALPHA, int AI, int E){
        kf=(double)KF/100;
        kr=(double)KR/100;
        alpha=(double)ALPHA/10;
        ai=(double)AI/10;
        epsilon=(double)E/1000;
    }
    
    public void GraphClear(){
        clearFlag=1;
    }
    
    public void StringClear(){
        clearFlag=2;
    }
            
    public void GraphInit(){
        defpat001=defpat002=defpat010=defpat012=defpat020=defpat021=defpat101=defpat102=defpat110=defpat112=defpat120=defpat121=defpat201=defpat201=defpat202=defpat210=defpat212=defpat220=defpat221=0;
        for(i=0;i<neurons;i++){
            if(pat[0][i]!=pat[1][i])    defpat001=defpat001+1;
            if(pat[0][i]!=pat[2][i])    defpat002=defpat002+1;
            if(pat[1][i]!=pat[0][i])    defpat010=defpat010+1;
            if(pat[1][i]!=pat[2][i])    defpat012=defpat012+1;
            if(pat[2][i]!=pat[0][i])    defpat020=defpat020+1;
            if(pat[2][i]!=pat[1][i])    defpat021=defpat021+1;
            
            
            if(pat2[0][i]!=pat2[1][i])    defpat101=defpat101+1;
            if(pat2[0][i]!=pat2[2][i])    defpat102=defpat102+1;
            if(pat2[1][i]!=pat2[0][i])    defpat110=defpat110+1;
            if(pat2[1][i]!=pat2[2][i])    defpat112=defpat112+1;
            if(pat2[2][i]!=pat2[0][i])    defpat120=defpat120+1;
            if(pat2[2][i]!=pat2[1][i])    defpat121=defpat121+1;
            
            if(pat3[0][i]!=pat3[1][i])    defpat201=defpat201+1;
            if(pat3[0][i]!=pat3[2][i])    defpat202=defpat202+1;
            if(pat3[1][i]!=pat3[0][i])    defpat210=defpat210+1;
            if(pat3[1][i]!=pat3[2][i])    defpat212=defpat212+1;
            if(pat3[2][i]!=pat3[0][i])    defpat220=defpat220+1;
            if(pat3[2][i]!=pat3[1][i])    defpat221=defpat221+1;
        }
        
        if(defpat001>50)    defpat001=100-defpat001;
        if(defpat002>50)    defpat002=100-defpat002;
        if(defpat010>50)    defpat010=100-defpat010;
        if(defpat012>50)    defpat012=100-defpat012;
        if(defpat020>50)    defpat020=100-defpat020;
        if(defpat021>50)    defpat021=100-defpat021;
        
        if(defpat101>50)    defpat101=100-defpat101;
        if(defpat102>50)    defpat102=100-defpat102;
        if(defpat110>50)    defpat110=100-defpat110;
        if(defpat112>50)    defpat112=100-defpat112;
        if(defpat120>50)    defpat120=100-defpat120;
        if(defpat121>50)    defpat121=100-defpat121;
        
        if(defpat201>50)    defpat201=100-defpat201;
        if(defpat202>50)    defpat202=100-defpat202;
        if(defpat210>50)    defpat210=100-defpat210;
        if(defpat212>50)    defpat212=100-defpat212;
        if(defpat220>50)    defpat220=100-defpat220;
        if(defpat221>50)    defpat221=100-defpat221;
        
        pat00y=(int)(Math.sin(Math.PI/6)*(double)(50-defpat001)-Math.sin(Math.PI/6)*(double)(50-defpat002)+50);
        pat01y=(int)(Math.sin(Math.PI/6)*(50)-Math.sin(Math.PI/6)*(double)(50-defpat012)+(50-defpat010));
        pat02y=(int)(Math.sin(Math.PI/6)*(double)(50-defpat021)-Math.sin(Math.PI/6)*(50)+(50-defpat020));
        
        pat00x=(int)(Math.cos(Math.PI/6)*(double)(50-defpat001)+Math.cos(Math.PI/6)*(double)(50-defpat002));
        pat01x=(int)(Math.cos(Math.PI/6)*(50)+Math.cos(Math.PI/6)*(double)(50-defpat012));
        pat02x=(int)(Math.cos(Math.PI/6)*(double)(50-defpat021)+Math.cos(Math.PI/6)*(50));
        
        pat10y=(int)(Math.sin(Math.PI/6)*(double)(50-defpat101)-Math.sin(Math.PI/6)*(double)(50-defpat102)+50);
        pat11y=(int)(Math.sin(Math.PI/6)*(50)-Math.sin(Math.PI/6)*(double)(50-defpat112)+(50-defpat110));
        pat12y=(int)(Math.sin(Math.PI/6)*(double)(50-defpat121)-Math.sin(Math.PI/6)*(50)+(50-defpat120));
        
        pat10x=(int)(Math.cos(Math.PI/6)*(double)(50-defpat101)+Math.cos(Math.PI/6)*(double)(50-defpat102));
        pat11x=(int)(Math.cos(Math.PI/6)*(50)+Math.cos(Math.PI/6)*(double)(50-defpat112));
        pat12x=(int)(Math.cos(Math.PI/6)*(double)(50-defpat121)+Math.cos(Math.PI/6)*(50));

        pat20y=(int)(Math.sin(Math.PI/6)*(double)(50-defpat201)-Math.sin(Math.PI/6)*(double)(50-defpat202)+50);
        pat21y=(int)(Math.sin(Math.PI/6)*(50)-Math.sin(Math.PI/6)*(double)(50-defpat212)+(50-defpat210));
        pat22y=(int)(Math.sin(Math.PI/6)*(double)(50-defpat221)-Math.sin(Math.PI/6)*(50)+(50-defpat220));
        
        pat20x=(int)(Math.cos(Math.PI/6)*(double)(50-defpat201)+Math.cos(Math.PI/6)*(double)(50-defpat202));
        pat21x=(int)(Math.cos(Math.PI/6)*(50)+Math.cos(Math.PI/6)*(double)(50-defpat212));
        pat22x=(int)(Math.cos(Math.PI/6)*(double)(50-defpat221)+Math.cos(Math.PI/6)*(50));
    }
    
    public void cleanNetworks(){
        for(int i=0;i<neurons;i++){
            x[i]=x2[i]=x3[i]=0;
            N[i]=N2[i]=N3[i]=0;
            L[i]=L2[i]=L3[i]=0; 
        }
    }

    public void calcWeight(){
    //calc waight
        for (i=0;i<neurons;i++){
          N[i]=N2[i]=N3[i]=0;
          L[i]=L2[i]=L3[i]=0;           
              for(j=0;j<neurons;j++){
                w[i][j]=0;
                w2[i][j]=0;
                w3[i][j]=0;
            }
          }
    for(i=0;i<neurons;i++){
      for(j=0;j<neurons;j++){
        for(p=0;p<patterns;p++){
          w[i][j]=w[i][j]+(2*(double)pat[p][i]-1)*(2*(double)pat[p][j]-1);
          w2[i][j]=w2[i][j]+(2*(double)pat2[p][i]-1)*(2*(double)pat2[p][j]-1);
          w3[i][j]=w3[i][j]+(2*(double)pat3[p][i]-1)*(2*(double)pat3[p][j]-1);
        }
        if(i==j){
          w[i][j]=0;
          w2[i][j]=0;
          w3[i][j]=0;
        }
        w[i][j]=(1/(double)patterns)*w[i][j];
        w2[i][j]=(1/(double)patterns)*w2[i][j];
        w3[i][j]=(1/(double)patterns)*w3[i][j];
      }
    }
    //calc
      gosa2[0]=gosa2[1]=gosa2[2]=100;
    }

  public double logistic( double y ){
    double re;
    re=1/(1+Math.exp(-1*y/epsilon));
    return re;
    
  }
  
  public double shiki1( double t, double w ){
    double re;
    re = kf*t+w;
    return re;
    
  }
  
  public double shiki2( double t , double x){
    double re;
    re = kr*t-alpha*x+ai;
    return re;
    
  }

  public double effect( int type ,int check1 , int check2 , int j){
    double tmp1,tmp2,tmp3;
    tmp3=0;

    if (type==0){
      tmp1=(pat[relation1_0[check1][0]][j]+pat[relation1_0[check1][1]][j])/2;
      tmp2=(pat[relation2_0[check2][0]][j]+pat[relation2_0[check2][1]][j])/2;
      tmp3=(tmp1+tmp2)/2;
    }else if(type==1){
      tmp2=(pat[relation2_0[check2][0]][j]+pat[relation2_0[check2][1]][j])/2;
      tmp3=tmp2;
    }else if(type==2){
      tmp1=(pat[relation1_0[check1][0]][j]+pat[relation1_0[check1][1]][j])/2;
      tmp3=tmp1;
    }else if(type==3){
      tmp1=(pat2[relation0_1[check1][0]][j]+pat2[relation0_1[check1][1]][j])/2;
      tmp2=(pat2[relation2_1[check2][0]][j]+pat2[relation2_1[check2][1]][j])/2;
      tmp3=(tmp1+tmp2)/2;
    }else if(type==4){
      tmp2=(pat2[relation2_1[check2][0]][j]+pat2[relation2_1[check2][1]][j])/2;
      tmp3=tmp2;
    }else if(type==5){
      tmp1=(pat2[relation0_1[check1][0]][j]+pat2[relation0_1[check1][1]][j])/2;
      tmp3=tmp1;
    }else if(type==6){
      tmp1=(pat3[relation0_2[check1][0]][j]+pat3[relation0_2[check1][1]][j])/2;
      tmp2=(pat3[relation1_2[check2][0]][j]+pat3[relation1_2[check2][1]][j])/2;
      tmp3=(tmp1+tmp2)/2;
    }else if(type==7){
      tmp2=(pat3[relation1_2[check2][0]][j]+pat3[relation1_2[check2][1]][j])/2;
      tmp3=tmp2;
    }else if(type==8){
      tmp1=(pat3[relation0_2[check1][0]][j]+pat3[relation0_2[check1][1]][j])/2;
      tmp3=tmp1;
    }
    return tmp3;
  }

  public void colorset(int check, int gosa,Graphics g){
    if(check==0 && gosa<1) g.setColor(Color.blue);
    else if(check==0 && gosa<10) g.setColor(Color.cyan);
    else if(check==1 && gosa<1) g.setColor(Color.red);
    else if(check==1 && gosa<10) g.setColor(Color.pink);
    else if(check==2 && gosa<1) g.setColor(new Color(0x009000));
    else if(check==2 && gosa<10) g.setColor(Color.green);
    else if(check==3 && gosa<1) g.setColor(Color.orange);
    else if(check==3 && gosa<10) g.setColor(Color.yellow);
    else g.setColor(Color.black);
  }
  
    public void paint (Graphics g){
        update(g);
    }
    
    public void update(Graphics g)
    {
        if(clearFlag==1){
         g.setColor(Color.white);
         g.fillRect(290,0,100,400);
         clearFlag=0;
        }
        
        if(clearFlag==2){
         g.setColor(Color.white);
         g.fillRect(200,410,220,20);
         clearFlag=0;
        }
        
        for(i=0;i<10;i++){
         for(j=0;j<10;j++){

             if(in[i*10+j]>0){
                 g.setColor(Color.gray);
                 g.fillRect(j*3+40,i*3+75,3,3);
             }
            else{
             g.setColor(Color.white);
             g.fillRect(j*3+40,i*3+75,3,3);
            }
            g.setColor(Color.black);
            g.drawRect(j*3+40,i*3+75,3,3);
            }
        }

         for(i=0;i<10;i++){
            for(j=0;j<10;j++){

                if(in2[i*10+j]>0){
                    g.setColor(Color.gray);
                    g.fillRect(j*3+40,i*3+205,3,3);
                }
                 else{
                     g.setColor(Color.white);
                     g.fillRect(j*3+40,i*3+205,3,3);
                }
                 g.setColor(Color.black);
                 g.drawRect(j*3+40,i*3+205,3,3);
            }
        }

        for(i=0;i<10;i++){
            for(j=0;j<10;j++){
        
                if(in3[i*10+j]>0){
                    g.setColor(Color.gray);
                    g.fillRect(j*3+40,i*3+335,3,3);
                }
                else{
                    g.setColor(Color.white);
                    g.fillRect(j*3+40,i*3+335,3,3);
                }
                g.setColor(Color.black);
                g.drawRect(j*3+40,i*3+335,3,3);
            }
        }        
        /////
       for(int q=0;q<3;q++){
        for(i=0;i<10;i++){
          for(j=0;j<10;j++){
            if(q==0){
              if(x[i*10+j]>0){
                int hoge=check[q];
                int haga=gosa2[q];
                colorset(hoge,haga,g);
                //              				g.setColor(Color.black);
//                g.fillRect(j*3+indentX*30+3*indentX,i*3+indentY*90+3*indentY+30*q,3,3);
                g.fillRect(j*10+100,i*10+40,10,10);
              }
              else{
                g.setColor(Color.white);
                g.fillRect(j*10+100,i*10+40,10,10);
              }
              g.setColor(Color.black);
              g.drawRect(j*10+100,i*10+40,10,10);
            }else if(q==1){
              if(x2[i*10+j]>0){
                int hoge=check[q];
                int haga=gosa2[q];
                colorset(hoge,haga,g);
                //              				g.setColor(Color.black);
                g.fillRect(j*10+100,i*10+170,10,10);
              }
              else{
                g.setColor(Color.white);
                g.fillRect(j*10+100,i*10+170,10,10);
              }
              g.setColor(Color.black);
              g.drawRect(j*10+100,i*10+170,10,10);              
            }else if(q==2){
              if(x3[i*10+j]>0){
                int hoge=check[q];
                int haga=gosa2[q];
                colorset(hoge,haga,g);
                //              				g.setColor(Color.black);
                g.fillRect(j*10+100,i*10+300,10,10);
              }
              else{
                g.setColor(Color.white);
                g.fillRect(j*10+100,i*10+300,10,10);
              }
              g.setColor(Color.black);
              g.drawRect(j*10+100,i*10+300,10,10);
            }
          }
        }
      }
      GraphPaint(g);
    }

    public void GraphPaint(Graphics g){
        int pat0X = 300;
        int pat0Y = 100;
        int pat1X = 300;
        int pat1Y = 230;
        int pat2X = 300;
        int pat2Y = 360;
        
        g.setColor(Color.black);
        g.drawLine(pat0X,pat0Y,pat0X,pat0Y-50);
        g.drawLine(pat0X,pat0Y,pat0X+43,pat0Y-25);
        g.drawLine(pat0X,pat0Y,pat0X+43,pat0Y+25);
        g.drawLine(pat1X,pat1Y,pat1X,pat1Y-50);
        g.drawLine(pat1X,pat1Y,pat1X+43,pat1Y-25);
        g.drawLine(pat1X,pat1Y,pat1X+43,pat1Y+25);
        g.drawLine(pat2X,pat2Y,pat2X,pat2Y-50);
        g.drawLine(pat2X,pat2Y,pat2X+43,pat2Y-25);
        g.drawLine(pat2X,pat2Y,pat2X+43,pat2Y+25);
        
        g.setColor(Color.red);
        g.fillOval(pat0X+pat00x-3,pat0Y-pat00y-3,6,6);
        g.fillOval(pat0X+pat01x-3,pat0Y-pat01y-3,6,6);
        g.fillOval(pat0X+pat02x-3,pat0Y-pat02y-3,6,6);
        g.fillOval(pat1X+pat10x-3,pat1Y-pat10y-3,6,6);
        g.fillOval(pat1X+pat11x-3,pat1Y-pat11y-3,6,6);
        g.fillOval(pat1X+pat12x-3,pat1Y-pat12y-3,6,6);
        g.fillOval(pat2X+pat20x-3,pat2Y-pat20y-3,6,6);
        g.fillOval(pat2X+pat21x-3,pat2Y-pat21y-3,6,6);
        g.fillOval(pat2X+pat22x-3,pat2Y-pat22y-3,6,6);    
        
        g.setColor(Color.blue);
        g.drawLine(pat0X+dx0o,pat0Y-dy0o,pat0X+dx0,pat0Y-dy0);
        g.drawLine(pat1X+dx1o,pat1Y-dy1o,pat1X+dx1,pat1Y-dy1);
        g.drawLine(pat2X+dx2o,pat2Y-dy2o,pat2X+dx2,pat2Y-dy2);
/*        
        g.setColor(Color.red);
        g.drawLine(pat0X+dx0-3,pat0Y-dy0-3,pat0X+dx0+3,pat0Y-dy0+3);
        g.drawLine(pat0X+dx0+3,pat0Y-dy0-3,pat0X+dx0-3,pat0Y-dy0+3);
        g.drawLine(pat1X+dx1-3,pat1Y-dy1-3,pat1X+dx1+3,pat1Y-dy1+3);
        g.drawLine(pat1X+dx1+3,pat1Y-dy1-3,pat1X+dx1-3,pat1Y-dy1+3);
        g.drawLine(pat2X+dx2-3,pat2Y-dy2-3,pat0X+dx2+3,pat2Y-dy2+3);
        g.drawLine(pat2X+dx2+3,pat2Y-dy2-3,pat0X+dx2-3,pat2Y-dy2+3);
        */
        
        g.setColor(Color.black);
        g.drawString("kf="+kf,200,420);
        g.drawString("kr="+kr,250,420);
        g.drawString("alpah="+alpha,300,420);
        g.drawString("ai="+ai,370,420);
        
        }

    private void advance()
    {
      for(i=0;i<neurons;i++){
        W=0;
        for(j=0;j<neurons;j++){
          if(signal!=signalratio || input_check[0]==0){//5-6,0.6-0.4
            if(gosa2[1]>=1 && gosa2[2]>=1){
              W=W+w[i][j]*x[j];
            }else if(gosa2[1]<1 && gosa2[2]<1){
              W=W+w[i][j]*(x[j]*feedback+effect(0,check[1],check[2],j)*gaibuin);
            }
            else if(gosa2[1]>=1 && gosa2[2]<1){
              W=W+w[i][j]*(x[j]*feedback+effect(1,check[1],check[2],j)*gaibuin);              
            }
            else if(gosa2[2]>=1 && gosa2[1]<1){
              W=W+w[i][j]*(x[j]*feedback+effect(2,check[1],check[2],j)*gaibuin);
            }
          }else{
            if(gosa2[1]>=1 && gosa2[2]>=1){
              W=W+w[i][j]*(x[j]*feedback+in[j]*gaibuin);
            }else if(gosa2[1]<1 && gosa2[2]<1){
              W=W+w[i][j]*(x[j]*feedback+(effect(0,check[1],check[2],j)*0.5+in[j]*0.5)*gaibuin);
            }
            else if(gosa2[1]>=1 && gosa2[2]<1){
              W=W+w[i][j]*(x[j]*feedback+((effect(1,check[1],check[2],j)+in[j])/2)*gaibuin);                            
            }
            else if(gosa2[2]>=1 && gosa2[1]<1){
              W=W+w[i][j]*(x[j]*feedback+((effect(2,check[1],check[2],j)+in[j])/2)*gaibuin);
            }
          }
        }
        N[i]=shiki1(N[i],W);
        L[i]=shiki2(L[i],x[i]);
        x[i]=logistic(N[i]+L[i]);
      }
      
      for(i=0;i<neurons;i++){
        W=0;
        for(j=0;j<neurons;j++){
          if(signal!=signalratio || input_check[1]==0){
            if(gosa2[0]>=1 && gosa2[2]>=1){
              W=W+w2[i][j]*x2[j];
            }else if(gosa2[0]<1 && gosa2[2]<1){
              W=W+w2[i][j]*(x2[j]*feedback+effect(3,check[0],check[2],j)*gaibuin);
            }
            else if(gosa2[0]>=1 && gosa2[2]<1){
              W=W+w2[i][j]*(x2[j]*feedback+effect(4,check[0],check[2],j)*gaibuin);
            }
            else if(gosa2[2]>=1 && gosa2[0]<1){
              W=W+w2[i][j]*(x2[j]*feedback+effect(5,check[0],check[2],j)*gaibuin);
            }
          }else{
            if(gosa2[0]>=1 && gosa2[2]>=1){
              W=W+w2[i][j]*(x2[j]*feedback+in2[j]*gaibuin);
            }else if(gosa2[0]<1 && gosa2[2]<1){
              W=W+w2[i][j]*(x2[j]*feedback+(effect(3,check[0],check[2],j)*0.5+in2[j]*0.5)*gaibuin);
            }
            else if(gosa2[0]>=1 && gosa2[2]<1){
              W=W+w2[i][j]*(x2[j]*feedback+((effect(4,check[0],check[2],j)+in2[j])/2)*gaibuin);                            
            }
            else if(gosa2[2]>=1 && gosa2[0]<1){
              W=W+w2[i][j]*(x2[j]*feedback+((effect(5,check[0],check[2],j)+in2[j])/2)*gaibuin);
            }
          }
        }
        N2[i]=shiki1(N2[i],W);
        L2[i]=shiki2(L2[i],x2[i]);
        x2[i]=logistic(N2[i]+L2[i]);
      }
      
      for(i=0;i<neurons;i++){
        W=0;
        for(j=0;j<neurons;j++){
          if(signal!=signalratio || input_check[2]==0){
            if(gosa2[0]>=1 && gosa2[1]>=1){
              W=W+w3[i][j]*x3[j];
            }else if(gosa2[0]<1 && gosa2[1]<1){
              W=W+w3[i][j]*(x3[j]*feedback+effect(6,check[0],check[1],j)*gaibuin);
            }
            else if(gosa2[0]>=1 && gosa2[1]<1){
            W=W+w3[i][j]*(x3[j]*feedback+effect(7,check[0],check[1],j)*gaibuin);
            }
            else if(gosa2[1]>=1 && gosa2[0]<1){
              W=W+w3[i][j]*(x3[j]*feedback+effect(8,check[0],check[1],j)*gaibuin);
            }           
          }else{
            if(gosa2[0]>=1 && gosa2[1]>=1){
              W=W+w3[i][j]*(x3[j]*feedback+in3[j]*gaibuin);
            }else if(gosa2[0]<1 && gosa2[1]<1){
              W=W+w3[i][j]*(x3[j]*feedback+(effect(6,check[0],check[1],j)*0.5+in3[j]*0.5)*gaibuin);
            }
            else if(gosa2[0]>=1 && gosa2[1]<1){
              W=W+w3[i][j]*(x3[j]*feedback+((effect(7,check[0],check[1],j)+in3[j])/2)*gaibuin);                            
            }
            else if(gosa2[1]>=1 && gosa2[0]<1){
              W=W+w3[i][j]*(x3[j]*feedback+((effect(8,check[0],check[1],j)+in3[j])/2)*gaibuin);
            }
          }
        }
        N3[i]=shiki1(N3[i],W);
        L3[i]=shiki2(L3[i],x3[i]);
        x3[i]=logistic(N3[i]+L3[i]);
      }
      
      
      signal=signal+1;
      if(signal==signalratio+1) signal=0;//7-8?
      
      //kenshou
      for(int q=0;q<3;q++){
        check[q] = 99;
        gosa2[q]=100;
        for(p=0;p<patterns;p++){
          gosa[q]=0;
          gosa3[q]=0;
          if(q==0){
            for(i=0;i<neurons;i++){
              if(x[i]>0) tmp=1; else tmp=0;
              if(tmp!=pat[p][i]) gosa[q] = gosa[q]+1;
            }
          }else if(q==1){
            for(i=0;i<neurons;i++){
              if(x2[i]>0) tmp=1; else tmp=0;
              if(tmp!=pat2[p][i]) gosa[q] = gosa[q]+1;
            }
          }else if(q==2){
            for(i=0;i<neurons;i++){
              if(x3[i]>0) tmp=1; else tmp=0;
              if(tmp!=pat3[p][i]) gosa[q] = gosa[q]+1;
            }
          }

        gosa3[q]=100-gosa[q];
        if(gosa[q]<=gosa2[q]){ gosa2[q] = gosa[q]; check[q]=p; }
        if(gosa3[q]<=gosa2[q]){gosa2[q] = gosa3[q];check[q]=p; }
        }        
      }

    //For Graph
        dy0o=dy0;
        dy1o=dy1;
        dy2o=dy2;
        dx0o=dx0;
        dx1o=dx1;
        dx2o=dx2;
        d00=d01=d02=d10=d11=d12=d20=d21=d22=0;
        dy0=dy1=dy2=dx0=dx1=dx2=0;
        for(i=0;i<neurons;i++){
            if(x[i]>0) z=1; else z=0;
            if(z!=pat[0][i])    d00=d00+1;
            if(z!=pat[1][i])    d01=d01+1;
            if(z!=pat[2][i])    d02=d02+1;
            
            if(x2[i]>0) z=1; else z=0;
            if(z!=pat2[0][i])    d10=d10+1;
            if(z!=pat2[1][i])    d11=d11+1;
            if(z!=pat2[2][i])    d12=d12+1;
            
            if(x3[i]>0) z=1; else z=0;
            if(z!=pat3[0][i])    d20=d20+1;
            if(z!=pat3[1][i])    d21=d21+1;
            if(z!=pat3[2][i])    d22=d22+1;
        }
        if(d00>50)    d00=100-d00;
        if(d01>50)    d01=100-d01;
        if(d02>50)    d02=100-d02;
        if(d10>50)    d10=100-d10;
        if(d11>50)    d11=100-d11;
        if(d12>50)    d12=100-d12;
        if(d20>50)    d20=100-d20;
        if(d21>50)    d21=100-d21;
        if(d22>50)    d22=100-d22;
        
        dy0=(int)(Math.sin(Math.PI/6)*(double)(50-d01)-Math.sin(Math.PI/6)*(double)(50-d02)+50-d00);
        dy1=(int)(Math.sin(Math.PI/6)*(double)(50-d11)-Math.sin(Math.PI/6)*(double)(50-d12)+50-d10);
        dy2=(int)(Math.sin(Math.PI/6)*(double)(50-d21)-Math.sin(Math.PI/6)*(double)(50-d22)+50-d20);

        dx0=(int)(Math.cos(Math.PI/6)*(double)(50-d01)+Math.cos(Math.PI/6)*(double)(50-d02));
        dx1=(int)(Math.cos(Math.PI/6)*(double)(50-d11)+Math.cos(Math.PI/6)*(double)(50-d12));
        dx2=(int)(Math.cos(Math.PI/6)*(double)(50-d21)+Math.cos(Math.PI/6)*(double)(50-d22));   
    }

}

