#!/usr/local/bin/perl
# Usage:
#  $COMMAND [PORT] [LIBNAME]
#
#      PORT: default='7001'
#   LIBNAME: default='default'

if($0 =~/loadClass/){
    $COMMAND='loadClass';
}
elsif($0 =~/saveClass/){
    $COMMAND='saveObject';
}
elsif($0 =~/loadInstance/){
    $COMMAND='loadObject';
}
elsif($0 =~/saveInstance/){
    $COMMAND='saveObject';
}

$PORT   =($ARGV[0] eq '')? 7001:$ARGV[0];
$LIBNAME=($ARGV[1] eq '')? 'default':$ARGV[1];
$SERVER = 'localhost';
use Socket;
$SIG{'ALRM'} = '_sigalrm';
alarm(60);

socket(S, AF_INET, SOCK_STREAM, getprotobyname('tcp'))
    || die "$0: socket: $!";
connect(S, sockaddr_in($PORT, inet_aton($SERVER)))
    || die "$0: cannot connect to: $PORT\n";
select(S); $| = 1; select(stdout);

#print STDERR "Library: $LIBNAME\n";

print S<<"EOF";
GET /$COMMAND?file=$LIBNAME HTTP/1.0

EOF

unless(index(<S>,'HTTP/1.0 200 OK')==0){
    die "$0: HTTP error!\n";
}
#else{
#    print STDERR "   ...done.\n";
#}
#while(! eof(S)){}
close(S);
exit;
#######################################

sub _sigalrm{
    die "$0: timeout.\n";
}
