#!/usr/local/bin/perl
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################

package AUTH;
# we must have defined class like this;
#
#  /**@key logname*/
#  Class User{
#       String logname;
#       Password password;
#  }
#
#  if therer is no instance of User, anyone can login without authentication.
#  so instantiate User as soon as possible.

sub init{
    if($DB::OBJECTID{User} eq '' || $main::ENV{NOMOSADMIN} eq '1' ){
	$Session::HTTP_HEADER{"Set-Cookie"}="user=admin.0; path=/";
	$Session::HTTP_ENV{'REMOTE_USER'} = 'admin';
	return ('first-time');
    }
    return ('');
}

sub setUserCookie{
    my($user,$path,$id)=@_;
    $user=&encode($user);
#    my($expire)=&mtime::cookieGMT(time+$Config::cookieTimeout);
#    $Session::HTTP_HEADER{"Set-Cookie"}="user=$user+$id; path=$path; expires=$expire";
    $Session::HTTP_HEADER{"Set-Cookie"}="user=$user+$id; path=$path";
}

sub unsetUserCookie{
    my($user,$path,$id)=@_;
    $user=&encode($user);
    $Session::HTTP_HEADER{"Set-Cookie"}="user=$user+$id; path=$path; expires=Monday, 01-Jan-1900 00:00:00 GMT"
}

sub setDataSet{
    my($user,$id,$uid)=@_;

    $user=&encode($user);
    &LoginHistory::loginUser("$user+$id",
			     $Session::HTTP_ENV{"Host"},
			     $Session::HTTP_ENV{"User-Agent"},
			     $uid);
    $Session::HTTP_ENV{'REMOTE_USER'}=$user;
    $Session::HTTP_ENV{'REMOTE_UID'}=$uid;
}

sub isValidDataSet{
    my($user,$password,$id)=@_;

    $user=&encode($user);

    my($uid)=
	&LoginHistory::isValidDataSet("$user+$id",
				      $Session::HTTP_ENV{"Host"},
				      $Session::HTTP_ENV{"User-Agent"});
    if( $uid ne ''){
	return($uid);
    }
    return('');
}

sub isValidLogin{
    my($user, $password )=@_;
    if($user ne '' ){
#&& $password ne '' 
	foreach(split(',',$DB::OBJECTID{User})){
	    if(&DB::getValue('User',$_,'logname') eq $user
	       && &DB::getValue('User',$_,'password') eq $password){
		return ($_);
	    }
	}
	return ('');
    }
    return ('');
}

sub checkPasswd{
#    print STDERR "---loginPasswdCheck---\n";
    my($user,$password) = @_;
    if(($uid=&isValidLogin($user,$password)) ne '' || $main::ENV{NOMOSADMIN} eq '1' || $Session::HTTP_ENV{'REMOTE_NAME'} eq 'localhost'){
	#
	# LOGIN SUCCEED.
	# 
	srand();
	my($id)=int(rand(65536));
	&setDataSet($user,$id,$uid);
	&setUserCookie($user,'/',$id);
	&Session::setRedirection;
	return('302 Redirected');
    }
    #
    # LOGIN FAILED.
    #
    return('200 OK', &showLoginFailed);
}

sub authCheck{
#    print STDERR "---authCheck---\n";
    my($user,$password);
    if(&init eq 'first-time' || ( $Session::HTTP_ENV{'REMOTE_NAME'} eq 'localhost' &&  $Session::HTTP_ENV{"Cookie"} eq 'user=admin.0')){
	#
	# ADMINISTRATION MODE
	#
	print STDERR "\n****** ADMINISTRATION MODE  ******\n" if ($Config::showSTDERR);
	&setDataSet('admin',0,0);
	&LoginHistory::updateTimeOutUser('admin+0');
	return('');
    }

    if($Session::HTTP_ENV{"Cookie"} =~ /user\=([\w\d\%]+)\+(\d+)/ ){
	$user = &Session::decode($1);
	my($id)   = $2;
	print STDERR "\n------$user------\n" if ($Config::showSTDERR);

	if(($uid=&isValidDataSet($user,$passowrd, $id)) ne ''){
	    # CORRECT!
	    &setDataSet($user,$id,$uid);
	    &LoginHistory::updateTimeOutUser("$user+$id");
#	    if($Session::HTTP_ENV{REQUEST_METHOD} eq 'POST'){
#		&setUserCookie($user,'/',$id);
#	    }
	    return('');
	}
	&LoginHistory::logoutUser("$user+$id");
#	&unsetUserCookie($user,'/', $id);
    }
    return('200 OK', &showLoginFailed);
}

sub LoginConsole{
    my($Body);

    $Body=<<"EndOfVal;";
<body bgcolof="$Config::bgColor">
<center>
<table><tr><td height="40"></td></tr>
<tr><td><img src="/img?file=login"></td></tr>
<tr><td height="40"></td></tr>
<tr><td align="center"><!--$message-->
<table>
<tr><td align="left">
<form action="/checkPasswd" method=POST>
̾:<input type=text name=user><P>
ѥ:<input type=password name=password>
<input type=submit value="LOGIN">
</form> </td></tr> 
</table>
</td></tr>
<tr><td height="20"></td></tr>
</table><p>
EndOfVal;
    return($Body);
}

sub showLoginConsole{
    my($ret);
    my($body)=&LoginConsole;
    my($footer)=&SHELL::makeFooter('4');
    
    $ret=<<"EndOfVal;";
<html><head><meta http-equiv="Content-Type" content="text/html; charset=x-euc-jp">
<title>  LOGIN  </title></head>
<body bgcolor="$Config::bgColor">
$body
<center><hr width="320"></center><br>
$footer
</body>
</html>
EndOfVal;
    return($ret);
}

sub showLoginFailed{
    my($ret);
    my($body)=&LoginConsole;
    my($footer)=&SHELL::makeFooter('4');
    $body=~s/<!--$message-->/<font color="red">ERROR: ̾ȥѥɤϤƤ<br>ѿȾѤϤƲ<\/font>/;
    $ret=<<"EndOfVal;";
<html><head><meta http-equiv="Content-Type" content="text/html; charset=x-euc-jp">
<title> HR DB LOGIN  </title></head>
<body bgcolor="#ffffff">
$body
<center><hr width="320"></center><br>
$footer
</body>
</html>
EndOfVal;
    return($ret);
}

sub encode {
    my($value) = @_;
    $value =~ s/(\W)/sprintf("%%%.2X", ord($1))/ge;
    $value =~ s/%20/+/g;
    return $value;
}

sub decode {
    my($value) = @_;
    $value =~ s/\+/ /g;
    $value =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/chr(hex($1))/ge;
    return $value;
}

sub isAdmin{
    my($class,$method)=@_;

    if($Session::HTTP_ENV{'REMOTE_USER'} eq 'admin'){
	$method = 0 + index( 'rnmd',$method );
    }elsif( &DB::getValue($class, $Session::TAGS{oid}, '.creator')
	   eq $Session::HTTP_ENV{'REMOTE_UID'}){
	$method = 4 + index( 'rnmd',$method );
    }else{
	$method = 8 + index( 'rnmd',$method );
    }

#    if(substr(&DB::getMode($class), $method, 1) ne '-' ||
#        $Session::HTTP_ENV{'REMOTE_NAME'} eq $main::SERVER_NAME ||
#       $Session::HTTP_ENV{'REMOTE_NAME'} eq 'localhost' 
#){
    if(substr(&DB::getMode($class), $method, 1) ne '-' || $main::ENV{NOMOSADMIN} eq '1' ){
	return('true');	    
    }else{
	return('false');
    }
}
1;
