#!/usr/local/bin/perl
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################

#------------------------------------------------------------#
sub CLASSOBJ{
    my($class,$change)=@_;
    my($sorter0,$sorter1,$sorter2,@dmy)=&DB::getSorter($class);
    if(&DB::isBaseClass($class) eq 'true'){
	return($class);
    }elsif($change ne ''){
	return("<a href=\"/getInstances?class=$class&sorter0=$sorter0&sorter1=$sorter1&sorter2=$sorter2\" target=\"_new\">"
	       .&DB::getName($class)."</a>");
    }else{
	return("<a href=\"/getInstances?class=$class&sorter0=$sorter0&sorter1=$sorter1&sorter2=$sorter2\">"
	       .&DB::getName($class)."</a>");
    }
}
sub CLASSOBJ2{
    my($class,$change,$name)=@_;
    if(&DB::isBaseClass($class) eq 'true'){
	return($name);
    }elsif($change ne ''){
	return("<a href=\"/getInstances?class=$class\" target=\"_new\">"
	       .$name."</a>");
    }else{
	return("<a href=\"/getInstances?class=$class\">"
	       .$name."</a>");
    }
}

sub INSTANCEOBJ{
    my($class,$oid,$change)=@_;
    if(&DB::isBaseClass($class) eq 'true'){
	return("<b>$class<b>");
    }elsif($change eq ''){
	return("<b><a href=\"getAttributes?class=$class&oid=$oid\">".&DB::getName($class,$oid)."</a></b>");
    }else{
	return("<b><a href=\"getAttributes?class=$class&oid=$oid\" target=\"_new\">".&DB::getName($class,$oid)."</a></b>");
	}
}
#--------------------------------------------------------------------------#

sub do_deleteInstance{
    my($Class,$oid)=@_;
    &DB::deleteObject($Class,$oid);
    &DB::deleteResource($Class,$oid);
    &DB::deleteOID($Class,$oid);
    &Log::sessionLog(&DB::checkOUT,$Session::HTTP_ENV{REMOTE_USER},
			'deleteInstance',
		     $Class,$oid);
}

sub do_setAttributes{
    my($Class, $oid)=@_;
    if($oid eq 'new'){
	$oid=&DB::getEmptyOID;
    }else{
	&DB::deleteObject($Class,$oid);
    }

    &DB::setObject($Class,$oid);
    &DB::setResource($Class,$oid);
    &DB::setOID($Class,$oid);
    &Log::sessionLog(&DB::checkOUT,$Session::HTTP_ENV{REMOTE_USER},
		     'setAttributes',
		     $Session::HTTP_ENV{QUERY_STRING}, $oid);
    return($oid);
}
#------------------------------------------------------------#
sub showGif{
    local($img)=@_;
    $Session::HTTP_HEADER{'Content-type'}='image/gif';
    return (&showContent("img/".$Config::Img{$img}));
}

sub showContent{
    my($file)=@_;

    if($file=~/\.html$/||$file=~/\.gif$/||$file=~/\.jpg$/||$file=~/\.jpeg$/){
	my($Body)='';
	open(IN,"<$file");
	while(<IN>){
	    $Body.=$_;
	}
	return($Body);
    }else{
	return('');
    }
}
#--------------------------------------------------------------------------#
sub do_search{
 my($KEYWORD)=@_;
 my(@Ret);
 my($key,$value);
 if($KEYWORD ne ''){
     while (($key,$value)=each(%DB::DEFINE)){
	 if(&DB::isBaseClass($value) eq 'true' && $value ne 'Password' ){
	     my($class,$valname)=split(/\:/,$key);
	     foreach(split(/\,/,$DB::OBJECTID{$class})){
#	     if(&DB::getValue($class,$_,$valname)=~/$KEYWORD/){
		 if(index(&DB::getValue($class,$_,$valname),$KEYWORD)>=0){
		     push(@Ret,"$class:$_:$valname");
		 }
	     }
	 }
     }
 }
 return(@Ret);
}

sub do_loadConfig{
    my($libName)=@_;
    my($TITLE)="եɤ߹";
   	
    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE : $libPath</h4>";

    &Config::load($libPath);

    return($Body);
}

sub do_loadClass{
    my($libName)=@_;
    my($TITLE)="饹եɤ߹";

    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE :$libPath</h4>";

    &ClassFile::loadClass($libPath);

    &DB::checkOUT;
    return($Body);
}

sub do_saveClass{
    my($libName)=@_;
    my($TITLE)="饹եν񤭽Ф";

    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE :$libPath</h4> done.";

    &ClassFile::saveClass($libPath);

    return($Body);
}

sub do_loadInstance{
    my($libName)=@_;
    my($TITLE)="󥹥󥹾եɤ߹";

    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE : $libPath</h4>\n";

    &DB::loadInstance($libPath);
    &DB::checkOUT;

    return($Body);
}
sub do_saveInstance{
    my($libName)=@_;
    my($TITLE)="󥹥󥹾եν񤭽Ф";

    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE : $libPath</h4>\n";

    &DB::savePlainTextData($libPath);

    return($Body);
}

sub do_loadObject{
    my($libName)=@_;
    my($TITLE)="饹󥹥󥹾եɤ߹";

    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE : $libPath</h4>\n";

    &ClassFile::loadClass($libPath);

    &DB::loadInstance($libPath);
    &DB::checkOUT;

    return($Body);
}

sub do_saveObject{
    my($libName)=@_;
    my($TITLE)="饹󥹥󥹾եν񤭽Ф";

    my($libPath)=&Init::path($libName,$main::libName);
    my($Body)=&makeHeader($TITLE)."<h4> $TITLE : $libPath</h4>\n";

    my($classfile);
    open(IN,"<$ClassFile::CLASSFILE");
    while(<IN>){$classfile=$_;}
    close(IN);
    open(OUT,">$libPath/base/$gloablData::CLASSFILE");
    print OUT $classfile;
    close(OUT);

    &DB::savePlainTextData($libPath);

    return($Body);
}

#sub do_showFile{
#    my($libName)=@_;
#    my($Body);
#    open(IN,"<$file");
#    close(IN);
#    read(FILEHANDLE,SCALAR,LENGTH);
#
#    &Config::load($libPath);
#
#    return($Body);
#}
#--------------------------------------------------------------------------#

1;




