#!/usr/local/bin/perl
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################
package DB;
CONFIG:{
    $OID=0;
    $LAST_MODIFIED=&mtime::GMT;
    $sortID=0;
}

sub checkIn{
}

sub checkOUT{
    my($time)=time;
    $LAST_MODIFIED=&mtime::GMT($time);
    return($time);
}

sub isBaseClass{
    my($arg)=@_;
    if(defined($arg) && ($arg eq 'String' || $arg eq 'Integer' 
       || $arg eq 'Text' || $arg eq 'Password')){
	return('true');
    }else{
	return('false');
    }
}

#---------------------------------------------------------
sub existsOID{
    local($oid)=@_;
    if(defined($OBJECT{$oid}) && $OBJECT{$oid} ne ''){
	return('true');
    }else{
	return('');
    }
}

sub getEmptyOID{
    do{
	$OID++;
    }while(defined($OBJECT{"$OID"}));
    return("$OID");
}

sub setOID{
    my($class,$oid)=@_;
    $OBJECTID{"$class"}=
	join(",", grep($_ ne $oid, split(',',$OBJECTID{"$class"}) ),$oid);
    $OBJECT{$oid}=1;
}

#---------------------------------------------------------
sub deleteOID{
    my($Class,$oid)=@_;
    $OBJECTID{$Class}=join(',',grep($oid ne $_, split(',',$OBJECTID{$Class})));
    $OBJECT{$oid}='';
    delete($OBJECT{$oid});
    &deleteResource($Class,$oid);
}

sub setObject{
    my($Class,$oid)=@_;
    my($key,$tmp);

    foreach $key (keys (%Session::TAGS)){

	if($key =~ /^([\w\d]+)\:([\d\w]+)\:([\w\d\.\[\]]+)\:/){
	    my($_class,$_oid,$_valname,$_value)=($1,$2,$3,$');
	    if ($_oid eq 'new'){
		$_oid = $oid;
	    }
	    if( &isBaseClass($DEFINE{"$_class:$_valname"}) eq 'true' ){
		#base
		$INSTANCE{"$_class:$_oid:$_valname"}=$Session::TAGS{$key};
		next;
	    }
	    if($_valname !~ /\]$/){
		#radio
		$INSTANCE{"$_class:$_oid:$_valname"}=$Session::TAGS{$key};
		$REFERER{$Session::TAGS{$key}}=
		    join(',',grep("$_class:$_oid:$_valname" ne $_,
				  split(',',$REFERER{$Session::TAGS{$key}})),
			 "$_class:$_oid:$_valname");
		next;
	    }else{
		#checkbox
		if( $Session::TAGS{$key} eq 'on' ){
		    $INSTANCE{"$_class:$_oid:$_valname"}=
			join(',',grep($_value ne $_,
				      split(',',$INSTANCE{"$_class:$_oid:$_valname"})),
			     $_value);
		    $REFERER{$_value}=
			join(',',grep("$_class:$_oid:$_valname" ne $_,
				      split(',',$REFERER{$_value})),
			     "$_class:$_oid:$_valname");
		}else{
		    $REFERER{$_value}=
			join(',',grep("$_class:$_oid:$_valname" ne $_,
				      split(',',$REFERER{$_value})));
		}
	    }
	}
    }
}

sub deleteObject{
    my($Class,$oid)=@_;
    foreach $val (split(",", $CLASS{$Class})){
	if(&isBaseClass($DEFINE{"$Class:$val"}) ne 'true'){
	    foreach $has (split(',',
				$INSTANCE{"$Class:$oid:$val"})){
		$REFERER{$has}=
		    join(',',
			 grep(! /^$Class\:$oid\:/,
			      split(',', $REFERER{$has})));
	    }
	}
	$INSTANCE{"$Class:$oid:$val"}='';
	delete($INSTANCE{"$Class:$oid:$val"});
    }
}

sub getUID{
   local($user)=@_;
	
    foreach(split(',',$DB::OBJECTID{User})){
       if(&DB::getValue('User',$_,'logname') eq $user ){
           return ($_);
	    }
	}
    return ("");
}


sub setResource{
    my($class,$oid)=@_;
    $uid=$Session::HTTP_ENV{'REMOTE_UID'};

    if( ! defined($INSTANCE{"$class:$oid:.creator"}) || $INSTANCE{"$class:$oid:.creator"} eq ''){
	$INSTANCE{"$class:$oid:.creator"}=$uid;
	$REFERER{"$uid"}=
	    join(',',grep("$class:$oid:.creator" ne $_,
			  split(',',$REFERER{"$uid"})),"$class:$oid:.creator");
    }

    $INSTANCE{"$class:$oid:.time"}=time;

    if(defined($Session::TAGS{"creator"}) && $ENV{NOMOSADMIN} eq '1' ){	
        $INSTANCE{"$class:$oid:.creator"}=&getUID($Session::TAGS{"creator"});
        $INSTANCE{"$class:$oid:.modifier"}=&getUID($Session::TAGS{"creator"});
    }else{
	$INSTANCE{"$class:$oid:.modifier"}=
	    join(',',grep($uid ne $_, split(',',$INSTANCE{"$class:$oid:.modifier"})),$uid);
    }

    $REFERER{"$uid"}=
	join(',',grep("$class:$oid:.modifier" ne $_,
		      split(',',$REFERER{"$uid"})),"$class:$oid:.modifier");
}

sub deleteResource{
    my($class,$oid)=@_;
    foreach $val ('.creator','.modifier','.time'){
	my($has)=$INSTANCE{"$class:$oid:$val"};
	$REFERER{$has}=
	    join(',', grep(! /^$class\:$oid\:/,
			   split(',',$REFERER{$has})));
	$INSTANCE{"$class:$oid:$val"}='';
	delete($INSTANCE{"$class:$oid:$val"});
    }
}
#---------------------------------------------------------
sub setCLASS{
    my($class,@val)=@_;
    $CLASS{"$class"}=(! defined($CLASS{"$class"}) || $CLASS{"$class"} eq '')?
	join(',',@val):join(',',($CLASS{"$class"},@val));
}

sub setDEFINE{
    my($class,$val,$VALNAME)=@_;
    $DEFINE{"$class:$val"}=$VALNAME;
}

sub setCOMMENT{
    my($class,$valname,$comment)=@_;
    if($valname ne ''){
	$COMMENT{"$class:$valname"}=$comment;

	my($param)='';

	foreach(split(/\n+/,$comment)){
	    if(/^[\s\*]*\@(\w+)\s+/){
		$param=$1;
		$OPTION{"$class:$valname:$param"}=$';
	    }elsif(/^\n[\s\*]*/){
		$OPTION{"$class:$valname:$param"}.="\n$'";
	    }
	}

	$OPTION{"$class:key"}=$valname if (! defined($OPTION{"$class:key"}) ||
					   $OPTION{"$class:key"} eq '');
	$OPTION{"$class:sorter"}=$valname if (! defined($OPTION{"$class:sorter"}) ||
					      $OPTION{"$class:sorter"} eq '');
    }else{
	$COMMENT{"$class"}=$comment;
	my($param)='';
	foreach(split(/\n/,$comment)){
	    if(/^[\s\*]*\@(\w+)\s+/){
		$param=$1;
		$OPTION{"$class:$param"}=$';
	    }elsif(/^[\s\*]*/){
		$OPTION{"$class:$param"}.="\n$'";
	    }
	}
	$OPTION{"$class:sortID"} = $sortID++;
	$OPTION{"$class:mode"}='rw--' if (! defined($OPTION{"$class:mode"}) ||
					  $OPTION{"$class:mode"} eq '');
    }
}

#---------------------#

sub checkExistenceSameKey{
    my($class)=@_;    
    my($tmp)=sprintf("$class:new:%s:",$OPTION{"$class:key"});
    my($name)=$Session::TAGS{"$tmp"};

    foreach $_ (&getInstances($class)){
	$tmp="$class:$_:".$OPTION{"$class:key"};
#	printf STDERR "------------------|$name, $tmp, ".$INSTANCE{"$tmp"}."|\n";

	if($name eq $INSTANCE{$tmp}){
	    return('true');
	}
    }
    return('false');

}


sub getOBJECTS{
    my($class,$oid,$valname)=@_;    
    my($ret)='';

    if($valname eq '.time'){
	return(&mtime::JSTstring(&getValue($class,$oid,$valname)));
    }
    if(&isBaseClass($class) eq 'true'){
	return(&getValue($class,$oid,$valname));
    }else{
	my(@_oid)=split(',',&getValue($class,$oid,$valname));
	my($_class)=&DB::getDefine($class,$valname);
	foreach $__oid (@_oid){
	    $ret.=&SHELL::INSTANCEOBJ($_class, $__oid,'').", ";
	}
    }
    return ($ret);
}

sub getValue{
    my($class,$oid,$valname)=@_;

    if(defined($oid) && $oid ne 'new' && $valname ne ''){
	return ((defined($INSTANCE{"$class:$oid:$valname"}))?$INSTANCE{"$class:$oid:$valname"}:'');
    }else{
	if(&isBaseClass(&getDefine($class,$valname)) eq 'true'){
	    return ((defined($Session::TAGS{"$class:new:$valname:"}))?$Session::TAGS{"$class:new:$valname:"}:'');
	}else{
	    my(@tmp,$val_escaped);
	    $val_escaped=($valname =~ /\[/)?$`:$valname;
#	    print STDERR "--------$valname  $val_excaped\n";
	    foreach(keys %Session::TAGS){
		if($_ eq "$class:new:$valname:"){
		    #radio
		    return($Session::TAGS{$_});
		}elsif(/$class:new:$val_escaped\[\]:/){
		    #checkbox
		    if(/^$class:new:$val_escaped\[\]:(\d+)/){
			push(@tmp,$1);
		    }
		}
	    }
	    return(join(',', @tmp));
	}
    }
}

sub getDescription{
    my($class,$oid,$id)=@_;
    my($valname)=$OPTION{"$class:description$id"};
    my($ret)='';

    my($_class)=&getDefine($class,$valname);

    if(&isBaseClass($_class) eq 'true'){
	$ret=&getValue($class,$oid,$valname);
    }else{
	my(@_oid)=split(',',&getValue($class, $oid, $valname));
	foreach $__oid (@_oid){
	    $ret.=&SHELL::INSTANCEOBJ($_class, $__oid,'').", ";
	}
    }
    return ($ret);
}

sub getName{
    my($class,$valname)=@_;

    if($valname=~/^\d+$/){
	my($name)=$INSTANCE{sprintf("%s:%s:%s",$class,$valname,$OPTION{"$class:key"})};

#	&DB::getDefine($class, $OPTION{"$class:key"});
	
	if($name !~/^\s*$/){
	    return($name);
	}
	return('???');
    }
#    if($valname=~/^[\d\,]+$/){
#	my($name);
#	my($valclass)=&DB::getDefine($class,$OPTION{"$class:key"});
#	if(&DB::IsBaseClass($valclass) eq 'true'){
#	    foreach(split(',', $INSTANCE{"$class::valclass"})){
#	    }
#	    return(&getName($valclass,$valname));
#	}else{
#	    $name=$INSTANCE{sprintf("%s:%s:%s",$class,$valname,$OPTION{"$class:key"})};
#    }
#	if($name !~/^\s*$/){
#	    return($name);
#	}
#	return('???');
#    }
    else{
	my($name);
	if($valname ne ''){
	    if($valname =~/^\./){
		if($valname eq '.creator'){
		    $name='';
		}
		elsif($valname eq '.modifier'){
		    $name='';
		}
		elsif($valname eq '.time'){
		    $name='';
		}
	    }else{
		$name=$OPTION{"$class:$valname:jname"};
	    }
	}else{
	    $name=$OPTION{"$class:jname"};
	}

	if($name ne ''){
	    return($name);
	}
	if($valname ne ''){
	    return($valname);
	}
	return($class);
    }
}

sub getBgColor{
    my($class,$valname)=@_;
    my($bg)=$OPTION{"$class:$valname:bgcolor"};
    if($bg ne ''){			
	return(sprintf("bgcolor=\"%s\"",$bg));
    }
	return('');
}

sub getSorter{
    my($class)=@_;
    if(! defined($OPTION{"$class:sorter0"}) || $OPTION{"$class:sorter0"} eq ''){
#	return('.time');
	return('');
    }else{
	return($OPTION{"$class:sorter0"},$OPTION{"$class:sorter1"},$OPTION{"$class:sorter2"},$OPTION{"$class:sorter3"});
    }
}

sub getKeyVal{
    my($class)=@_;
    return $OPTION{"$class:key"}
}

sub getMode{
    my($class)=@_;    
    return $OPTION{"$class:mode"};
}

sub getColRow{
    my($class, $valname)=@_;
    print STDERR "$class:$valname:cols,",$OPTION{"$class:$valname:cols"}."*******\n";
    my($cols)=($OPTION{"$class:$valname:cols"} ne '')?
	$OPTION{"$class:$valname:cols"}:$Config::FormColSize;
    my($rows)=($OPTION{"$class:$valname:rows"} ne '')?
	$OPTION{"$class:$valname:rows"}:$Config::FormRowSize;
    return($cols,$rows);
}

#---------------------#
sub getResource{
    my($class,$oid)=@_;
    my(@tmp)=split(',',$INSTANCE{"$class:$oid:.modifier"});
    return( $INSTANCE{"$class:$oid:.creator"},
	   $tmp[$#tmp],
	   $INSTANCE{"$class:$oid:.time"}
	   );
}
sub getClasses{
    return(sort { $DB::OPTION{"$a:sortID"} <=> $DB::OPTION{"$b:sortID"}; } (keys %CLASS));
}

sub getPkgname{
    my($Class)=@_;
    return($OPTION{"$Class:package"});
}

sub getComment{
    my($Class)=@_;
    return($COMMENT{"$Class"});    
}
sub getInstances{
    my($Class)=@_;
    return(split(/,/,$OBJECTID{"$Class"}));
}
sub getDefine{
    my($Class,$valname)=@_;
    return('String') if($valname eq '.time');
    return('User') if($valname eq '.creator' || $valname eq '.modifier');
    return($DB::DEFINE{"$Class:$valname"});
}
sub getReferer{
    my($oid)=@_;
    return(split(",", $REFERER{"$oid"}));
}
sub getDefinitions{
    my($Class)=@_;
    my(@Ret,%Def,%Com);
    my(@Valiables)=split(',',$CLASS{"$Class"});

    foreach (@Valiables){
	push(@Ret, &getDefine($Class,$_)."\t".$_."\t".$COMMENT{"$Class:$_"});
    }
    return(@Ret);
}
sub getAttributes{
    my($Class,$oid)=@_;
    my(@Ret);
    foreach (split(',',$CLASS{"$Class"})){
	push(@Ret, sprintf ("%s\t%s\t%s",
			    $DEFINE{"$Class:$_"},
			    $_,
			    &getValue($Class, $oid, $_),
			    )
	     );
    }
    return(@Ret);
}
#---------------------#
sub undefDB{
    undef(%CLASS) if(defined %CLASS);
    undef(%DEFINE) if(defined %DEFINE);
    undef(%VALIABLE) if(defined %VALIABLE);
    undef(%OPTION) if(defined %OPTION);
    $sortID=0;
}

sub undefObjects{
    my($libPath)=@_;
#    if(-e "$libPath/init"){
	print STDERR "   [initializing dbm]\n" if ($Config::showSTDERR);
	print STDERR "\tOBJECTID\n" if ($Config::showSTDERR);
          foreach $key (keys %OBJECTID) {
               delete $OBJECTID{$key};
          }
	print STDERR "\tREFERER\n" if ($Config::showSTDERR);
          foreach $key (keys %REFERER) {
               delete $REFERER{$key};
          }
	print STDERR "\tINSTANCE\n" if ($Config::showSTDERR);
          foreach $key (keys %INSTANCE) {
               delete $INSTANCE{$key};
          }
	print STDERR "\tOBJECT\n" if ($Config::showSTDERR);
          foreach $key (keys %OBJECT) {
               delete $OBJECT{$key};
          }
	print STDERR "   ...done.\n" if ($Config::showSTDERR);
#    }
}

sub initCache{
    my($mode)=@_;
    if($mode eq 'pre'){
	foreach $_ ('REFERER','INSTANCE','OBJECT'){
            for($i=0; $i<$Config::cacheMemory; $i++){
	       ${$_}{"$i"}='';
	    }
        }
    }else{
	foreach $_ ('REFERER','INSTANCE','OBJECT'){
            for($i=0; $i<$Config::cacheMemory; $i++){
	        if( defined( %{$_} ) && defined ${$_}{$i} ){
		undef(${$_}{"$i"});
              	}
            }
        }
    }
}

sub openDBM{
    my($libPath)=@_;
    print STDERR "  [opening dbm: $Config::DBM]\n" if ($Config::showSTDERR);

    if(defined($Config::DBM) && $Config::DBM ne ''){

	tie(%OBJECTID,$Config::DBM.'_File',"$libPath/dbm/Objectid", O_RDWR|O_CREAT, 0640);
	tie(%REFERER,$Config::DBM.'_File',"$libPath/dbm/Referer", O_RDWR|O_CREAT, 0640);
	tie(%INSTANCE,$Config::DBM.'_File',"$libPath/dbm/Instance", O_RDWR|O_CREAT, 0640);
	tie(%OBJECT,$Config::DBM.'_File',"$libPath/dbm/Object", O_RDWR|O_CREAT, 0640);
    }else{
	dbmopen(%OBJECTID,"$libPath/dbm/Objectid",0770);
	dbmopen(%REFERER, "$libPath/dbm/Referer", 0770);
	dbmopen(%INSTANCE,"$libPath/dbm/Instance",0770);
	dbmopen(%OBJECT,  "$libPath/dbm/Object",  0770);
    }
}

sub closeDBM{
    my($libPath)=@_;
    print STDERR "   [closing dbm]\n" if ($Config::showSTDERR);
    if($Config::DBM eq 'NDBM'){
	untie(%OBJECTID);
	untie(%REFERER);
	untie(%INSTANCE);
	untie(%OBJECT);
    }else{
	dbmclose(%OBJECTID);
	dbmclose(%REFERER);
	dbmclose(%INSTANCE);
	dbmclose(%OBJECT);
    }
    print STDERR "   ...done\n" if ($Config::showSTDERR);
}

sub removeDBM{
    my($libPath)=@_;
    unlink("$libPath/dbm/Objectid", "$libPath/dbm/Referer",
	   "$libPath/dbm/Instance", 
	   "$libPath/dbm/Object");
}

sub loadPlainTextData{
    my($libPath)=@_;
#    if(-e "$libPath/plain"){
	print STDERR "   [loading plain-text data]\n" if ($Config::showSTDERR);
    my($f)='';
	foreach $f ('OBJECTID','INSTANCE'){
	    print STDERR "\t$libPath/txt/$f\n" if ($Config::showSTDERR);
#	    if(! -r "$libPath/txt/$f"){
#		print STDERR "ERROR READING: $libPath/txt/$f\n";
#		return;
#	    }
	    open(IN,"<$libPath/txt/$f");
	    my(%dmy);
	    while($line=<IN>){
		if($line=~/(\S+)\t/){
		    my($key)=($1);
		    chop($val=$');
#		    print STDERR "$key:$val\n";
		    $val=~s/
/\n/go;
#		    if(($val=~s///go) == 0){
#		    }
		    $dmy{$key}=$val;
		}
	    }
	    close(IN);
	    %{$f}=%dmy;
	    undef(%dmy);
	}

	while(($key,$val)=each %OBJECTID){
	    foreach(split(',',$val)){
		$OBJECT{$_}=$key;
		if(int($_)>=$OID){
		    $OID=int($_);
		}
	    }
	}

	my($key,$val);
	while(($key,$val)=each(%INSTANCE)){
	    if($key =~ /^([\w\d]+)\:(\d+)\:([\w\d\.\[\]]+)/){
		my($class,$oid,$valname)=($1,$2,$3);
		if( &isBaseClass($DEFINE{"$class:$valname"}) eq 'false' ){
		    foreach $_oid (split(',', $val)){
			$REFERER{$_oid}=(defined($REFERER{$_oid}) && $REFERER{$_oid} ne '')?
			    join(',',grep($key ne $_,
					  split(',',$REFERER{$_oid})),$key):$key;
		    }
		}
	    }
	}

	print STDERR "   ...done.\n" if ($Config::showSTDERR);
#    }
}

sub savePlainTextData{
    my($libPath)=@_;
#    if(-e "$libPath/plain"){
	print STDERR "   [saving plain-text data]\n" if ($Config::showSTDERR);
	foreach('OBJECTID','INSTANCE'){
	    open(OUT,">$libPath/txt/$_");
	    my($key,$val);
#	    while(($key,$val)=each(%{$_})){
	    foreach $key (sort keys (%{$_})){
		$val=${$_}{"$key"};
#		$val=~s///go;
		$val=~s/
//go;
		$val=~s/\n/
/go;

		printf OUT ("%s\t%s\n",$key,$val);
	    }
	close(OUT);
	}
    print STDERR "   ...done.\n" if ($Config::showSTDERR);
#    }
}

sub loadInstance{
    my($libPath)=@_;
    &initCache('pre');
    &openDBM($libPath);
    &initCache('after');
    &undefObjects($libPath);
    &loadPlainTextData($libPath);
    return();
}

sub saveInstance{
    my($libPath)=@_;
    &savePlainTextData($libPath);
    &closeDBM($libPath);
    &removeDBM($libPath);
}

1;
