#!/usr/local/bin/perl
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################

package HTTPD;
CONFIG:{
    use Socket;
}

sub setup_server{
    my($port) = @_;
    $sockaddr = 'S n a4 x8';
    ($name, $aliases, $proto) = getprotobyname('tcp');
    $sin = pack($sockaddr, &AF_INET, $port, "\0\0\0\0");
    socket(S, AF_INET, SOCK_STREAM, $proto) || return('');
    setsockopt(S,SOL_SOCKET, SO_REUSEADDR, 1) || return('');
#    setsockopt(SOCKET,LEVEL,OPTNAME,OPTVAL);
    bind(S, $sin) || return('');
    listen (S, $Config::ConnectionQue) || return('');
    return($sin);
}

sub shutdown_server{
    close(NS);
    close(S)||die;
}

#------------------------------------------------------------------------
sub server{
    my($sin) = @_;
    my($sessionNo)=0;
    while(1){
	$sessionNo++; # sessionNo is global
	&do_CONNECTION($sin,$sessionNo);
    }
}

sub do_CONNECTION{
    my($sin,$sessionNo) = @_;

    my($addr, $STATUS, $HttpContent, $HttpHeaders, $key, $value);
    ($addr = accept(NS,S)) || return 1;
    my($port, $iaddr) = sockaddr_in(getpeername(NS));
    $STATUS=500;
#    select(NS); $| = 1;select(STDOUT);$| = 1;
    if ($Config::showSTDERR){
	&Session::init(gethostbyaddr($iaddr, AF_INET),inet_ntoa($iaddr));
	print STDERR "Session $sessionNo [$Session::HTTP_ENV{REMOTE_NAME}]\{\n"
	    if ($Config::showSTDERR);
	($STATUS, $HttpContent )=&do_Session();
	$Session::HTTP_HEADER{"Content-length"}=length($HttpContent);
	$HttpHeaders=&Session::makeHTTP_HEADER();
	
	print NS "HTTP/1.0 $STATUS\n".$HttpHeaders.$HttpContent;
	close(NS);
    }else{
#	eval '
	&Session::init(gethostbyaddr($iaddr, AF_INET),inet_ntoa($iaddr));
	print STDERR "Session $sessionNo [$Session::HTTP_ENV{REMOTE_NAME}]\{\n"
	    if ($Config::showSTDERR);
	($STATUS, $HttpContent )=&do_Session();
	$Session::HTTP_HEADER{"Content-length"}=length($HttpContent);
	$HttpHeaders=&Session::makeHTTP_HEADER();
	
	print NS "HTTP/1.1 $STATUS\n".$HttpHeaders.$HttpContent;
	close(NS);
#';
    }
    if ($Config::showSTDERR){
	print STDERR "HTTP/1.0 $STATUS\n".$HttpHeaders;
	if ($Session::HTTP_HEADER{'Content-type'}=~/^text/){
	    print STDERR $HttpContent;
	}
	print STDERR "}\n";
    }
    &Log::accessLog($STATUS);
    return 0;
}

#------------------------------------------------------------------------
sub do_Session{
    my($STATUS, $SCRIPT_NAME,$QUERY_STRING );
    my($HTML);

    ($STATUS,$SCRIPT_NAME,$QUERY_STRING)=&do_HTTP();

    if($SCRIPT_NAME ne '' && $QUERY_STRING ne ''){
	&Session::setTAGS($QUERY_STRING);	    
    }
    if ($Config::showSTDERR){
	print STDERR "\t(($SCRIPT_NAME))\n";
	my($key,$val);
	while(($key,$val)= each(%Session::HTTP_ENV)){
	    print STDERR "\t$key: $val\n"
		if ($Config::showSTDERR);
	}
    }

    if($STATUS eq ''){
	($STATUS, $HTML)
	    = &SHELL::makeBody($SCRIPT_NAME);
    }

    if($STATUS eq '' && length($HTML)==0){
	$STATUS="500 Internal Server Error";
    }
    if( $STATUS eq "302 Moved Temporarily" ){
	$HTML='';
	return($STATUS, $HTML);
    }
    if($STATUS ne "200 OK" ){
	$HTML="<font size=+2>$STATUS</font><br>".$HTML;
    }

    if($Session::HTTP_HEADER{'Content-type'} =~/^text/){
	&jcode::convert(*HTML, 'jis', 'euc', 'z');
    }
    return($STATUS, $HTML);
}

sub do_HTTP{
    my($REQUEST_METHOD,$URI);
    my($STATUS,$SCRIPT_NAME,$QUERY_STRING)=('','','');
    chop($_=<NS>);chop($_);
    $Session::ReqLine=$_;
    if ($Session::ReqLine =~ /^(\S+)\s(\S+)\sHTTP\/(\S+)/) {
	($REQUEST_METHOD,$URI)=($1,$2);
	if($REQUEST_METHOD ne 'GET' && $REQUEST_METHOD ne 'POST' 
	   && $REQUEST_METHOD ne 'HEAD'){
	    # unknown method
	    $STATUS='501 Not Implemented';
	    return($STATUS, $SCRIPT_NAME, $QUERY_STRING);
	}
    }else{
	# bad protocol
	$STATUS='400 Bad Request';
	return($STATUS, $SCRIPT_NAME, $QUERY_STRING);
    }

    &do_Head();
    ($SCRIPT_NAME,$QUERY_STRING)
	=&do_CGI($REQUEST_METHOD,$URI);

    $SCRIPT_NAME=($SCRIPT_NAME =~/\//)?$':$SCRIPT_NAME;
    return($STATUS, $SCRIPT_NAME, $QUERY_STRING);
}

#------------------------------------------------------------------------
sub do_Head{
    do{
	$line=<NS>||return;
	if ($line =~/^\s+$/){
	    # empty-line is the sepalater of Header and Content
	    return;
	}
	# parse each Header -- CGI-Environments
	my($n) = index($line,':');
	if ( $n >= 0 ) {
	    my($key,$val);
	    $key = substr($line, 0 , $n);
	    $val = substr($line, $n+2 );
	    $val = ($val=~/\s+$/)?$`:$val;
	    $Session::HTTP_ENV{"$key"}=$val;
	}
	#end of Head:
    }while(! eof(NS));
    return;
}

sub do_CGI{
    my($REQUEST_METHOD,$URI)=@_;
    my($QUERY_STRING);
    # parse each Arguments -- CGI-TAGs

    if ($REQUEST_METHOD eq 'GET' ){
	if( $URI =~/\?/) {
	    $QUERY_STRING=$';
	    $SCRIPT_NAME=$`;
	    if( $QUERY_STRING =~/\/$/){chop($QUERY_STRING);}
	}else{ 
	    $SCRIPT_NAME=$URI;
	}
    }elsif ($REQUEST_METHOD eq 'POST') {
	$SCRIPT_NAME=$URI;
	my($CONTENT_LENGTH)=0;
	my($len)=$Session::HTTP_ENV{'Content-length'};

	while($len - $CONTENT_LENGTH > 0 ){
	    my($tmp);
	    $CONTENT_LENGTH +=
		read(NS, $tmp, int($len) - $CONTENT_LENGTH );
	    $QUERY_STRING.=$tmp;
	}
    }
    return($SCRIPT_NAME,$QUERY_STRING);
}

1;
