#!/usr/local/bin/perl
package Init;

sub forkChild{
    my($libName,$FORCED,$DEBUG)=@_;

    my($libdir)=&path($libName);
    my($pidfile)=$libdir.'/log/'.$Config::PIDFILE;
    if(-r $pidfile){
	if($FORCED==1){
	    open(PID,"<$pidfile");
	    my($pid)=<PID>;
	    close(PID);
	    print STDERR "killing another nomos... $pidfile: $pid\n";
	    kill 2, $pid;#-INT
	    sleep(4);
	    unlink("$pidfile");
	}else{
	    print STDERR "ERROR: Another nomos may be running.\n     Please kill nomos and clean $pidfile\n";
           exit 1;
	}
    }
    if($DEBUG>0){
	&writePid($libName,$$);
    }else{
	if($pid = fork) {
	    &writePid($libName,$pid);
	    exit 0;
	}
    }
    &writePort($libName);

}
sub writePid{
    my($libName,$pid)=@_;
    my($libdir)=&path($libName);
    my($pidfile)=$libdir.'/log/'.$Config::PIDFILE;
    open(PID,">$pidfile")||die "cannot write $pidfile.\n";
    print PID "$pid";
    close(PID);
}
sub writePort{
    my($libName)=@_;
    my($libdir)=&path($libName);
    my($portfile)=$libdir.'/log/'.$Config::PORTFILE;
    open(PORT,">$portfile")||die "cannot write $portfile.\n";
    print PORT "$main::SERVER_PORT";
    close(PORT);
}
sub initSystem{
    my($libName,$SERVER_PORT,$FORCED)=@_;
    print STDERR "\nstartup server $main::SERVER_NAME:$main::SERVER_PORT\n\n" 
	if ($Config::showSTDERR);
    my($libPath)=&path($libName);
    my($sin);
    my($retry)=0;

    while(1){
	$sin=&HTTPD::setup_server($SERVER_PORT);
	if($sin ne ''){
	    if($retry!=0){
		print STDERR "starting server...\n";
	    }
	    last;
	}

	if($FORCED != 1){
	    print STDERR "bind: Address already in use\nexit.\n";
	    unlink($libPath.'/log/'.$Config::PIDFILE);
	    unlink($libPath.'/log/'.$Config::PORTFILE);
		exit(1);
	}
	print STDERR "bind: $!\n";
	print STDERR " try again automatically in 20 seconds\n";
	sleep(20);
    }

    &DB::removeDBM($libPath);
    print STDERR "< loading library : $libName >\n"
	if ($Config::showSTDERR);

    &ClassFile::loadClass($libPath);

    print STDERR "  [opening logfiles]\n"
	if ($Config::showSTDERR);
    &Log::openLog($libPath);
    print STDERR "  ...done.\n"
	if ($Config::showSTDERR);

    &DB::loadInstance($libPath);

    print STDERR "...done.\n"
	if ($Config::showSTDERR);

    print STDERR "\ninitialization finished.\nserver started.\n"
	if ($Config::showSTDERR);
    return($sin);
}


sub path{
    my($libName,$defaultLibName)=@_;    
    my($libPath)='';
    if($libName ne ''){
	if($libName =~ /^\.\./ || $libName =~ /\/\.\./){
	    #ERROR!
	    # use default
	    $libPath="$Config::LIBDIR/default";
	}else{
	    $libPath="$Config::LIBDIR/$libName";
	}
    }else{
	if($defaultLibName eq ''){
            # use default
	    $libPath="$Config::LIBDIR/default";
	}else{
	    $libPath="$Config::LIBDIR/$defaultLibName";
	}
    }
    &mkLIBDIR($libPath);
    return($libPath);
}

sub mkLIBDIR{
    my($libPath)=@_;

    my($dir)='';
    foreach(split('/',$libPath)){
	$dir.="$_";
	unless(-d "$dir"){
	    mkdir("$dir",0770);
	}
	$dir.='/';
    }

    unless(-d "$libPath/base"){
	mkdir("$libPath/base",0770);
    }
    unless(-d "$libPath/dbm"){
	mkdir("$libPath/dbm",0770);
    }
    unless(-d "$libPath/txt"){
	mkdir("$libPath/txt",0770);
    }
    unless(-d "$libPath/log"){
	mkdir("$libPath/log",0770);
    }
    unless(-e "$libPath/base/$Config::CONFFILE"){
	open(OUT,">$libPath/base/$Config::CONFFILE");
	close(OUT);
    }
    unless(-e "$libPath/base/$Config::CLASSFILE"){
	open(OUT,">$libPath/base/$Config::CLASSFILE");
	print OUT<<'EOF';
/**
@mode rnmdr---
@jname 桼
@description1 logname
@description2 email
*/
class User{
    /**
	@jname ̾
	@bgcolor #ffffff
	*/
    String realname;

    /**
	@jname ̾
	@comment ¾ͤȽŤʤʤ褦
	@bgcolor #ffffff
	*/
    String logname;

    /**
	@jname ѥ
	@bgcolor #ffffff
	*/
    Password password;

    /**
	@jname E-mailɥ쥹
	@bgcolor #ffffff
	*/
    String email;
}
EOF
	close(OUT);
    }
}
1;
