#!/usr/local/bin/perl
require 'bin/modules/table.pl';
require 'bin/modules/misc.pl';
require 'bin/modules/showValiables.pl';
require 'bin/modules/showClass.pl';
require 'bin/modules/hr.pl';

#############################################################################

sub showReferer{
    my($Class,$oid,@oids)=@_;
    if(@oids){
	my($prevClass,$prevValname)=('','');
	my($_class,$_oid,$_valname,%tmp,$total,%total_class,%total_valname);

	foreach $ref (sort (@oids)){
	    ($_class,$_oid,$_valname)=split(/\:/, $ref);
	    $tmp{"$_class:$_valname"}.="$_oid,";
	    $total_class{"$_class"}++;
	    $total_valname{"$_class:$_valname"}++;
	}
	my($Body)=sprintf("<hr><font size=+1>ξ򻲾ȤƤ<font size=-1>(%d)</font></font>\n",
			  $#oids+1);
	$Body.="<ul>";

	foreach(sort(keys %tmp)){
	    ($_class,$_valname)=split(/\:/, $_);	    
	
	    if($prevClass ne $_class || $prevValname ne $_valname){
	        my($valname)=&DB::getName($_class,$_valname);
		if($prevClass eq '' && $prevValname eq ''){
		    my($CLASSOBJ)=&CLASSOBJ($_class);
		    $Body.=sprintf("<li>$CLASSOBJ(%d)<ul><li>$valname(%d)<br>",
				   $total_class{"$_class"},
				   $total_valname{"$_class:$_valname"});
		}
		elsif($prevClass eq $_class && $prevValname ne $_valname){
		    $Body.=sprintf("<li>$valname(%d)<br>",
				   $total_valname{"$_class:$_valname"});
		}
		elsif($prevClass ne $_class){
		    my($CLASSOBJ)=&CLASSOBJ($_class);
		    $Body.=sprintf("</ul><p><li>$CLASSOBJ(%d)<ul><li>$valname(%d)<br>",
				   $total_class{"$_class"},
				   $total_valname{"$_class:$_valname"});
		}
	    }
	    $prevClass=$_class;
	    $prevValname=$_valname;
	    foreach $__oid (split(',',$tmp{$_})){
		    my($INSTANCEOBJ)=&INSTANCEOBJ($_class,$__oid);
		    $Body.="$INSTANCEOBJ, ";
		}
        }
	$Body.='</ul></ul>';
	return($Body);
    }else{
	return('');
    }
}

sub showInstanceList{
    my(@Obj)=@_;
    my($Body)='<ul>';
    foreach(@Obj){
	my($class,$oid,$valname)=split(/\:/,$_);
	my($Valname)=&DB::getName($class,$valname);
	my($value)=&DB::getValue($class,$oid,$valname);
	my($INSTANCEOBJ)=&INSTANCEOBJ($class,$oid);
	my($CLASSOBJ)=&CLASSOBJ($class);
	$Body.=<<"EndOfValiable;";
<li>$CLASSOBJ $INSTANCEOBJ $Valname = <a href="/getAttributes?class=$class&oid=$oid">$value</a>
EndOfValiable;
    }
    $Body.='</ul>';
    return($Body);
}



#############################################################################

sub showInstances{
    my($Class,@Sorter)=@_;

    my($TITLE)="Class \"".&DB::getName($Class)."\" (instances)";
    my($Body)=&makeHeader($TITLE)."\n<h3><a href=\"/\">ۡ</a>:<a href=\"/getClasses\"></a>:<font size=+2 color=red>"
	.&DB::getName($Class)."</font> - <font size=-1>(<font color=\"#e00000\">ܰ</font>/<a href=\"/showTableV?class=$Class\">ư</a>/<a href=\"/showTableH?class=$Class\">ư</a>)</font></h3>\n";
#    $Body.=&showInstancesCore($Class);
#    $Body.=&makeSearcher;
    my($selected,$URL)=('','');
    $Body.="<form name=\"sorter\">";

    for($i=0;$#Sorter>=$i;$i++){
	$URL.="+'&sorter$i='+form.sorter$i.options[form.sorter$i.selectedIndex].value";
    }

    for($i=0;$#Sorter>=$i;$i++){
	$Body.="<select name=\"sorter$i\" onChange=\"window.location.replace('/getInstances?class=$Class'$URL)\">";
	$Body.="<option value=\"\">\n";
	foreach(&DB::getDefinitions($Class),"User\t.creator","User\t.modifier","String\t.time"){
	    my($class,$valname,@dmy)=split("\t",$_);
	    $selected=($Sorter[$i] eq $valname)?'selected':'';
	    $Body.="<option value=\"$valname\" $selected>".&DB::getName($Class,$valname)."\n";
	}
	$Body.="</select>\n";
    }

    $Body.="</form>\n";

    if(@Sorter){
	$Body.="<dl>\n";
	$Body.=&showSortableInstancesCore($Class,@Sorter);
	$Body.='</dl>';
    }else{
	$Body.='<ul>';
	($s,@dmy)=&DB::getSorter($Class);
	$Body.=&showInstancesCore($Class,$s);
	$Body.='</ul>';
    }
    $Body.=&Console($Class,'','');
    $Body.="<hr>".&makeFooter(3);
    return($Body);
}

sub showSortableInstancesCore{
    local($Class,@Sorter)=@_;

    my($Body);
    my(%sorterKey,$oid,$k);
    my(@prevSorter,@sorter,$padding);
    my(@oid)=&DB::getInstances($Class);
    if(@oid){
	my(@sorter);
	foreach(@oid){
	    # Ѥͤ
	    my($s,$k)=('','');
	    for($i=0;$#Sorter>=$i;$i++){
		$sorter[$i] = &getAnAttributeDefined($Class, $_, $Sorter[$i], '');
		$k .= $sorter[$i]."\t";
	    }
	    $sorterKey{$k}=(defined($sorterKey{$k}))?$sorterKey{$k}.','.$_ : $_;
	}

#ʬ<DL>Ȥäƽľ
#ʤȡdescriptionͥȤƤޤ

	foreach (sort keys %sorterKey){
	    foreach $oid (sort split(',', $sorterKey{$_})){
		$padding='';
		my($changed)=0;
		for($i=0;$#Sorter-1>=$i;$i++){
		    $padding.='';
		    $sorter[$i]= &getAnAttributeDefined($Class, $oid, $Sorter[$i], '');
		    if(($sorter[$i] ne $prevSorter[$i] || $changed==1 )&& $Sorter[$i] ne ''){
			$Body.="<dt><font size=-1>$padding$sorter[$i]</font><br>\n";
			$changed=1;
		    }
		    $prevSorter[$i] = $sorter[$i];
		}
		$padding.='';
		
		$Body.="<font size=-1>$padding</font>".
		    &getAnAttributeDefined($Class,
					   $oid, $Sorter[$#Sorter], '').
					       '-'.&showAnInstance($Class,$oid).
						   "<br>\n";
	    }
	}
    }else{
	$Body.='( ϿƤޤ )';
    }
    return($Body);
}

sub showAnInstance{
    my($Class,$oid)=@_;
    my($name)=&DB::getName($Class,$oid);
    my(@ret)=(split(',',$DB::REFERER{$oid}),'');
    my($REFOBJ)='';

    my($description);
    my($description1,$description2)=(&DB::getDescription($Class,$oid,1),&DB::getDescription($Class,$oid,2));
    $description1=($Session::TAGS{'desc1'} ne '')?$Session::TAGS{'desc1'}:$description1;
    $description2=($Session::TAGS{'desc2'} ne '')?$Session::TAGS{'desc2'}:$description2;

    if($description1 ne '' ){
	$description="$description1";
    }
    if($description2 ne ''){
	$description.="<br>$description2";
    }
    if($#ret>0){$REFOBJ="<font size=-1>($#ret)</font>";}
    return( &INSTANCEOBJ($Class,$oid).$REFOBJ.' <font size=-2>'.$description."</font>\n" );
}

sub showInstancesCore{
    my($Class,$Sorter)=@_;
    my(@oid)=&DB::getInstances($Class);
    my($Body)='';
    $SORTER=$Sorter;
    if(@oid){
	foreach(sort sorter @oid){
	    my($name)=&DB::getName($Class,$_);
	    my(@ret)=(split(',',$DB::REFERER{$_}),'');
	    my($REFOBJ)='';
	    my($description1,$description2,$description)
		=(&DB::getDescription($Class,$_,1), &DB::getDescription($Class,$_,2), '');
	    if($description1 ne '' && $description2 ne ''){
		$description='  '.$description1.'<br>'.$description2;
	    }
	    elsif($description1 ne ''){
		$description='  '.$description1;
	    }elsif($description2 ne ''){
		$description='<br>'.$description2;
	    }

	    if($#ret>0){$REFOBJ="<font size=-1>($#ret)</font>";}
	    if($Session::TAGS{blink} eq $_){
		$Body.="<li><blink>".&INSTANCEOBJ($Class,$_)."</blink>".$REFOBJ." <font size=-2>$description</font>\n";
	    }else{
		$Body.="<li>".&INSTANCEOBJ($Class,$_).$REFOBJ." <font size=-2>$description</font>\n";
	    }
	}
    }else{
	$Body.='( ϿƤޤ )';
    }
    return($Body);
}


#-------------------------------------------------------------------------------#

sub showAttributes{
    my($class,$oid,$change,$mode)=@_;
    my($tmp,$digest)=&showAttributesCore($class,$oid,$change,$mode);
    my($Body)="<table><tr><td>\n$tmp\n</td></tr><tr><td align=left>\n";
    if($change eq ''){
	$Body.=&showObjectResource($class,$oid,$change);
    }
    $Body.='</td></tr></table>';
    return($Body,$digest);
}

sub showAttributesCore{
    my($Class,$Oid,$change,$mode)=@_;
    my($digest)='';
    my($Body)="<table border>\n";
    foreach(&DB::getAttributes($Class,$Oid)){
	my($class,$valname,$value) = split(/\t/);
	my($comment)='';
	if($change ne ''){
	    if($DB::OPTION{"$Class:$valname:comment"} ne ''){
		$comment="<br><font size=-3 color=#990000>".
		    $DB::OPTION{"$Class:$valname:comment"}."</font>";
	    }
	}
	my($padding) = $DB::OPTION{"$Class:$valname:padding"};
	if($padding ne ''){
	    if($mode eq 'digest'){
		$digest='true';
		last;
	    }
	    $Body.=<<"EndOfValiable;";
<tr><td colspan=2><hr noshade size=$padding></tr>
EndOfValiable;
	}
	my($bg)=&DB::getBgColor($Class,$valname);
	my($valobj) = &CLASSOBJ2($class, $change, &DB::getName($Class, $valname));
	my($defobj) = &getAnAttributeDefined($Class, $Oid, $valname, $change);
	my($newobj) = &getAnAttributeForm($Class, $Oid, $valname);
	$Body.=<<"EndOfValiable;";
<tr><td width=23% rowspan=1 $bg>$valobj</td><td $bg>$defobj</td></tr>
EndOfValiable;
	if($change ne ''){
		$Body.=<<"EndOfValiable;";
<tr><td align=left valign=top>$comment</td><td $bg>$newobj</td></tr>
EndOfValiable;
	}
    }
    $Body.='</table>';
    return($Body, $digest);
}

sub getAnAttributeDefined{
    local($Class, $Oid, $valname, $change)=@_;
    my($class)=&DB::getDefine($Class, $valname);
    my($value)=&DB::getValue($Class, $Oid, $valname);
    my($defobj)=('');
    if($class eq 'String' || $class eq 'Integer' ){
	# Class 'String' and 'Integer' is base Class.
	# the value is directed to the real-value.
	if($valname =~/^URL/){
	    $defobj="<a href=\"$value\">$value</a>";
	}elsif($valname eq '.time' && $value ne ''){
	    $defobj=sprintf("<!--$value-->%s",&mtime::JSTstring($value));
	}else{
	    $defobj=$value;
	}
    }elsif($class eq 'Text' ){
	$value=~s/\n/<br>/go;
	$defobj="<font size=-1>$value</font>";
    }elsif($class eq 'Password' ){
	$defobj=$value;
	$defobj=~s/./*/go;
    }else{
	# the other Classes are Foundation Class.
	# the value is redirected to the relative-value(oid).
	if( &DB::getDefine($Class, $valname) ne ''){
	    @_oid=split(',',$value);
	    $SORTER='';
	    foreach $_oid (sort sorter @_oid){
		$defobj.='<!--'.&DB::getName($class, $_oid).'-->'.
		    &INSTANCEOBJ($class,$_oid,$change).', ';
	    }
	}
    }
    return($defobj);
}

sub getAnAttributeForm{
    local($Class, $Oid, $valname)=@_;
    my($class)=&DB::getDefine($Class, $valname);
    my($value)=&DB::getValue($Class, $Oid, $valname);
    my($newobj)=('');
    if($class eq 'String' || $class eq 'Integer' ){
	# Class 'String' and 'Integer' is base Class.
	# the value is directed to the real-value.

	my($cols,$rows) = &DB::getColRow( $Class, $valname );
	$newobj="<input type=text size=$cols name=\"$Class:$Oid:$valname:\" value=\"$value\">";
    }elsif($class eq 'Text' ){
	my($cols,$rows) = &DB::getColRow($class, $valname);
	$newobj="<textarea name=\"$Class:$Oid:$valname:\" cols=$cols rows=$rows>$value</textarea>";
    }elsif($class eq 'Password' ){
	$newobj="<input type=password name=\"$Class:$Oid:$valname:\" value=\"$value\">";
    }else{
	my($n)=0;

	$SORTER='';
	foreach $__oid (sort sorter &DB::getInstances($class)){
	    if(grep($__oid eq $_, @_oid)){
		$checked='checked';
		$selected='selected';
	    }else{
		$checked='';
		$selected='';
	    }

	    if($valname =~/\[(\d*)\]$/){
		$newobj.="<input type=checkbox name=\"$Class:$Oid:$valname:$__oid\" $checked> ".&INSTANCEOBJ($class,$__oid,$change).', ';
	    }elsif($valname =~/\_$/){
		$newobj.="<input type=radio name=\"$Class:$Oid:$valname:\" value='$__oid' $checked> ".&INSTANCEOBJ($class,$__oid,$change).', ';
	    }else{
		$newobj.="<option value=\"$__oid\" $selected>".&DB::getName($class,$__oid)."\n";
	    }
	}
	if($valname !~/\]$/ && $valname !~ /\_$/){
	    $newobj="<select name=\"$Class:$Oid:$valname:\"><option value=\"\">\n$newobj</select>\n";
	}
    }
    return($newobj);
}


sub showInstance{
    my($class,$oid,$change,$mode,$msg)=@_;
    my($objectName)=&DB::getName($class,$oid);
    my($Body);

    if($oid ne '' && $oid ne 'new' && &DB::existsOID($oid) eq ''){
	return(&emptyAlart($class,$oid));
    }
    my($nextmode);
    my($TITLE)="Class \"".$class."\" Instance \"$objectName\"";
    $Body.=&makeHeader($TITLE)
	."\n$msg<h3><a href=\"/\">ۡ</a>:<a href=\"/getClasses\"></a>:".&CLASSOBJ($class,$change)
	    .":<font color=red size=+2>$objectName</font></h3>\n";

    if($change ne ''){
	if($mode eq 'digest'){
	    $Body.=<<"EndOfValiable;";
    <form name=f action="/setAttributes" method="POST">
	<input type=hidden name=class value=$class>
	<input type=hidden name=oid value=$oid>
        <input type=hidden name=change value="true">
        <input type=hidden name=mode value="advanced">
EndOfValiable;
	}elsif($mode eq 'advanced'){
	    $Body.=<<"EndOfValiable;";
    <form name=f action="/setAttributes" method="POST">	    
	<input type=hidden name=class value=$class>
	<input type=hidden name=oid value=$oid>
	<input type=hidden name=mode value="submit">
EndOfValiable;
	}else{
	    $Body.=<<"EndOfValiable;";
    <form name=f action="/setAttributes" method="POST">
	<input type=hidden name=class value=$class>
	<input type=hidden name=oid value=$oid>
	<input type=hidden name=mode value=submit>
EndOfValiable;
	}
    }
    
    my($tmp,$digest)=&showAttributes($class,$oid,$change,$mode);
    $Body.=$tmp;

    if($change ne ''){
	$Body.=<<"EndOfValiable;";
<table border=0 cellspacing=0>
<tr><td colspan=2>ʾξϿޤ<br>Ǥ<br></td></tr>
EndOfValiable;
	if($mode eq 'digest'){
	    if($digest eq ''){
		$Body.=<<"EndOfValiable;";
<tr><td align=top><input type="submit" value="ξϿ" onClick="f.mode.value='submit'"></td>
EndOfValiable;
	    }else{
		$Body.=<<"EndOfValiable;";
<tr>
<td align=top><input type="submit" value="ξϿ" onClick="f.mode.value='submit'"></td>
<td align=top><input type="submit" value="ܺپɲϤ" onClick="f.mode.value='advanced'"></td>
EndOfValiable;
	    }
	}else{
	    $Body.=<<"EndOfValiable;";
<tr><td align=top><input type="submit" value="ξϿ"></td>
EndOfValiable;
	}
	$Body.=<<"EndOfValiable;";
<td align=top><input type="button" value="ä" onClick="self.close()"></td></tr>
</table>
</form>
EndOfValiable;
    }else{
	$Body.=&showReferer($class,$oid, &DB::getReferer($oid));
	$Body.=&Console($class,$oid,$change);
	$Body.="<hr>".&makeFooter(3);
    }

    return($Body);
}

sub sorter{
    if(@_){
	my($Class)=@_;
    }
    my($SORTER,@dmy)=($SORTER ne '')?$SORTER:&DB::getSorter($Class);
    if(&DB::isBaseClass(&DB::getDefine($Class,$SORTER)) eq 'true'){
	&DB::getValue($Class, $a, $SORTER) cmp &DB::getValue($Class, $b, $SORTER);
    }else{
	my($_a,$_b)=('','');
	foreach(split(',', &DB::getValue($Class,$a,$SORTER))){
	    $_a.=&getAnAttributeDefined(&DB::getDefine($Class,$SORTER), $_, '')."\t";
	}
	foreach(split(',', &DB::getValue($Class,$b,$SORTER))){
	    $_b.=&getAnAttributeDefined(&DB::getDefine($Class,$SORTER), $_, '')."\t";
	}
	$_a cmp $_b;
    }
}

#-----------------#
1;
