#!/usr/local/bin/perl
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################

package Log;
#127.0.0.1 - - [03/Aug/1997:23:43:28 +0900] "GET / HTTP/1.0" 200 124

sub openLog{
    local($path)=@_;

    if(! -d "$path"){
	mkdir ("$path", 0770);
    }
    if(! -d "$path/log"){
	mkdir ("$path/log", 0770);
    }
    if($Config::ACCESS_LOG ne ''){
	open(ACCESSLOG,">>$path/log/$Config::ACCESS_LOG");
	select(ACCESSLOG);$|=1;select(STDOUT);
    }
    if($Config::SESSION_LOG ne ''){
	open(SESSIONLOG,">>$path/log/$Config::SESSION_LOG");
	select(SESSIONLOG);$|=1;select(STDOUT);
    }
}

sub closeLog{
    close(ACCESSLOG) if($Config::ACCESS_LOG ne '');
    close(SESSIONLOG) if($Config::SESSION_LOG ne '');
}
sub sessionLog{
    print SESSIONLOG join("\t",@_)."\n" if($Config::SESSION_LOG ne '');
}

sub accessLog{
    my($status)=@_;
    if($Config::ACCESS_LOG ne ''){
	printf ACCESSLOG ("%s - %s [%s] \"%s\" %d %d\n",
			  $Session::HTTP_ENV{REMOTE_NAME},
			  $Session::HTTP_ENV{REMOTE_USER},
			  &mtime::JSTlogstr(''),
			  $Session::ReqLine,
			  substr($status,0,index($status,' ')),
			  $Session::HTTP_HEADER{'Content-length'}
			  );
    }
}

1;
