#!/usr/local/bin/perl
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################

package SHELL;

CONFIG:{
    require "bin/modules/Core.pl"||die;
    require "bin/modules/Interface.pl"||die;
    $init=1;
}

sub makeBody{
    my($COMMAND)=@_;
  
    $Session::HTTP_HEADER{'Content-type'}='text/html';

    if($COMMAND eq 'img' ){
	return("200 OK", &SHELL::showGif($Session::TAGS{file}));
    }
    if($COMMAND eq 'login' ){
	return("200 OK", &AUTH::showLoginConsole);
    }elsif($COMMAND eq 'checkPasswd'){
	return(&AUTH::checkPasswd($Session::TAGS{user},
				  $Session::TAGS{password}));
    }

    my($STATUS, $HTML);

    if($main::ENV{NOMOSADMIN} ne '1'){
	($STATUS, $HTML) = &AUTH::authCheck;
    }

    if($STATUS eq ''){
	return (&do_cmd($COMMAND));
    }else{
	return($STATUS, $HTML);
    }
}

sub do_cmd{
    my($Body);
    my($cmd)=@_;

#    if($cmd eq 'content'){
#	$Body=&do_showFile($Session::TAGS{file});
#    }
    if($ $cmd eq '' ){
	$Body=&$Config::ROOTFUNC;
    }

    if( &AUTH::isAdmin($Session::TAGS{class}) eq 'true'){
	if($cmd eq 'admintool'){
	    $Body=&showMenu;
	}
	if($cmd eq 'loadConfig' ){
	    $Body=&do_loadConfig($Session::TAGS{file});
	}
	elsif($cmd eq 'loadClass' ){
	    $Body=&do_loadClass($Session::TAGS{file});
	}
	elsif($cmd eq 'saveClass' ){
	    $Body=&do_saveClass($Session::TAGS{file});
	}
	elsif($cmd eq 'loadInstance' ){
	    $Body=&do_loadInstance($Session::TAGS{file});
	}
	elsif($cmd eq 'saveInstance' ){
	    $Body=&do_saveInstance($Session::TAGS{file});
	}
	elsif($cmd eq 'loadObject' ){
	    $Body=&do_loadObject($Session::TAGS{file});
	}
	elsif($cmd eq 'saveObject' ){
	    $Body=&do_saveObject($Session::TAGS{file});
	}
    }

    if($cmd eq 'getAttributes'){
	if($Session::TAGS{oid} eq 'new' && 
	   &AUTH::isAdmin($Session::TAGS{class},'n') ne 'true'){
	    $Body='You do not have permission (new).';
	}elsif($Session::TAGS{oid} ne 'new' && $Session::TAGS{change} ne '' &&
	       &AUTH::isAdmin($Session::TAGS{class},'m') ne 'true'){
	    $Body='You do not have permission (modify).';
	}else{
	    if(&AUTH::isAdmin($Session::TAGS{class},'r') eq 'true'){
		$Body=&showInstance($Session::TAGS{class},
				    $Session::TAGS{oid},
				    $Session::TAGS{change},
				    $Session::TAGS{mode},'');
	    }else{
		$Body='You do not have permission (read).';
	    }
	}
    }

    elsif($cmd eq 'setAttributes'){
	if($Session::TAGS{oid} eq 'new' &&
	   &AUTH::isAdmin($Session::TAGS{class},'n') ne 'true'){
	    $Body='You do not have permission (new).';
	}elsif($Session::TAGS{oid} ne 'new' &&
	       &AUTH::isAdmin($Session::TAGS{class},'m') ne 'true'){
	    $Body='You do not have permission (modify).';
	}else{
	    if($Session::TAGS{mode} eq 'submit'){

		if(&DB::checkExistenceSameKey($Session::TAGS{class}) eq 'true'){
		    $msg=&WarnExistSameKey($Session::TAGS{class},
					   $Session::TAGS{oid});
		    if(&AUTH::isAdmin($Session::TAGS{class},'r') eq 'true'){
			$Body.=&showInstance($Session::TAGS{class},
					    $Session::TAGS{oid},
					    $Session::TAGS{change},
					    $Session::TAGS{mode},$msg);
		    }else{
			$Body='You do not have permission (read).<br>'.$msg;
		    }
		}

		$oid=&do_setAttributes($Session::TAGS{class},
				       $Session::TAGS{oid});
		$Body=&ConfirmPrompt().&SHELL::reloadOpener("&blink=$oid");

	    }else{
		if(&AUTH::isAdmin($Session::TAGS{class},'r') eq 'true'){
		    $Body=&showInstance($Session::TAGS{class},
					  $Session::TAGS{oid},
					  $Session::TAGS{change},
					  $Session::TAGS{mode},'');
		}else{
		    $Body='You do not have permission (read).';
		}
	    }
	}
    }

    if( $cmd eq 'deleteInstance' ){
	if(&AUTH::isAdmin($Session::TAGS{class},'d') ne 'true' ){
	    $Body='You do not have permission (delete).';
	}else{
	    $Body=&showDeleteInstance($Session::TAGS{class},
				      $Session::TAGS{oid});
	}
    }
    elsif( $cmd eq 'DeleteInstance'){
	if( &AUTH::isAdmin($Session::TAGS{class},'d') ne 'true'){
	    $Body='You do not have permission (delete).';
	}else{
	    &do_deleteInstance($Session::TAGS{class},
			       $Session::TAGS{oid});
	    $Body=&SHELL::reloadOpenerSelfCloser('');
	}
    }

    if($cmd eq 'getClasses'){
	$Body=&showClasses;
    }
    elsif($cmd eq 'getInstances'){
	$Body=&showInstances($Session::TAGS{class},
			     $Session::TAGS{sorter0},$Session::TAGS{sorter1},$Session::TAGS{sorter2});
#	$Body.=&showValiables($Session::TAGS{class})
#	    if($Session::HTTP_ENV{'REMOTE_USER'} eq 'admin');
    }

    elsif($cmd eq 'showTableV'){
	$Body=&showTableVertical($Session::TAGS{class});
    }
    elsif($cmd eq 'showTableH'){
	$Body=&showTableHorizontal($Session::TAGS{class});
    }
    elsif($cmd eq 'search'){
	my(@ret)=&do_search($Session::TAGS{arg});
	$Body=&showSearchForm($Session::TAGS{arg}, @ret);
	$Body.=&showInstanceList(@ret);
	$Body.="<hr>";
	$Body.=&makeFooter(3);
    }
    elsif($cmd eq 'about' ){
	$Body=&showAbout;
    }

    elsif($cmd eq 'showPlainTableHorizontal' ){
	$Session::HTTP_HEADER{'Content-type'}='text/plain';
	return('200 OK', &showPlainTableHorizontal($Session::TAGS{class}));
    }
    elsif($cmd eq 'showPlainTableVertical' ){
	$Session::HTTP_HEADER{'Content-type'}='text/plain';
	return('200 OK', &showPlainTableVertical($Session::TAGS{class}));
    }
    elsif($cmd eq 'getLibName'){
	$Session::HTTP_HEADER{'Content-type'}='text/plain';
	return('200 OK', $main::ROOT.'/'.&Init::path($main::libName));
    }

    if($Body eq ''){
	return('404 Not Found','');
    }

    return('200 OK', $Body);
}

#-------------------------------------------------------------------#

1;
