#!/usr/local/bin/perl
# Objective Shell Httpd (chttpd)
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
######################################################################
package Session;
#
# $Session::TAGS{name}='value';
# $Session::HTTP_ENV{name}='value';
#
# $Session::HTTP_HEADER{'Content-type'}='text/html';

sub init{
    my($REMOTE_HOST,$REMOTE_ADDR)=@_;

    undef($ReqLine) if (defined $ReqLine);
    undef(%TAGS) if (defined %TAGS);
    undef(%HTTP_ENV)  if (defined %HTTP_ENV);
    undef(%HTTP_HEADER) if (defined %HTTP_HEADER);
    $HTTP_ENV{REMOTE_NAME}=($REMOTE_HOST ne '')?$REMOTE_HOST:$REMOTE_ADDR;
    $HTTP_ENV{REMOTE_HOST}=$REMOTE_HOST;
    $HTTP_ENV{REMOTE_ADDR}=$REMOTE_ADDR;
}

sub setHTTP_ENV{
    my(@env)=@_;
    while(@env){
	$key=shift(@env);
	$val=shift(@env);
	$HTTP_ENV{$key}=$val;
    }
}


sub setRedirection{
    if(   $Session::HTTP_ENV{Referer} =~ /\/checkPasswd$/
       || $Session::HTTP_ENV{Referer} =~ /\/login$/ ){
	$Session::HTTP_HEADER{Location}='/';
    }else{
	$Session::HTTP_HEADER{Location}=
	    $Session::HTTP_ENV{Referer};
    }
}

sub makeHTTP_HEADER{
    &DB::checkOUT();
    my($DATE)=&mtime::GMT;
    my($HTTP_HEADERS);

    if($HTTP_HEADER{'Content-type'} !~ /^image/){
	$HTTP_HEADER{'Expires'} =$DB::LAST_MODIFIED;
	$HTTP_HEADER{'Pragma'}  ='no-cache';
    }
    while(($key,$val)=each %HTTP_HEADER){
	$HTTP_HEADERS.="$key: $val\n";
    }

    my($ret);
#    if($HTTP_ENV{REQUEST_METHOD} eq 'GET' ||
#       $HTTP_ENV{REQUEST_METHOD} eq ''){
#	$ret.="Pragma: no-cache\n";
#    }
#Pragma: no-cache
#Cache-Control: no-cache
#Cache-Control: max-state=0

    $ret.=<<"EndOfValiables;";
Date: $DATE
Server: $main::SERVER_SOFTWARE
Last-modified: $DB::LAST_MODIFIED
$HTTP_HEADERS
EndOfValiables;

    return($ret);
}

sub encode {
    my($value) = @_;
    $value =~ s/(\W)/sprintf("%%%.2X", ord($1))/ge;
    $value =~ s/%20/+/g;
    return $value;
}

sub decode {
    my($value) = @_;
    $value =~ s/\+/ /g;
    $value =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/chr(hex($1))/ge;
    return $value;
}

sub normalTAGS{
    my($arg)=@_;
    my($key, $value) = split(/=/, $arg, 2);
    $key = &decode($key);
    $value = &decode($value);
    &jcode::convert(*value, 'euc');
    &jcode::h2z_euc(*value);kill

#    my($from)='£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڣ r s t u v w x y z';
#    my($to)=' 0123456789ABCDEFGHIJKMNOPQRSTUVWXYZabcdefghijklmnopq';
#    for($i=0;$i<length($from);$i+=2){
#	$fromchar = substr($from,$i,2);
#	$tochar = substr($to,$i/2,1);
#	$value =~ s/($char)/$to/g;
#    }

#    $value=~tr//;
#    &jcode::tr(*value, "","0123456789");
#    &jcode::tr(*value, "£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣","ABCDEFGHIJKMNOPQRSTUVWXYZ");
#    &jcode::tr(*value, "","abcdefghijklmnopqrstuvwxyz");
#    &jcode::tr(*value, ""," ");

    return($key, $value);
}

sub setTAGS{
    local($QUERY_STRING)=@_;
    my($arg);
    $HTTP_ENV{QUERY_STRING}=$QUERY_STRING;
    foreach $arg (split('&', $QUERY_STRING)) {
	my($key,$value)=&normalTAGS($arg);
	$TAGS{$key}=$value;
	push(@TAGS,$key);
	print STDERR "\t\t$key=$value\n" if ($Config::showSTDERR);
    }
}

sub checkHTTPAgent{
    if( $Session::HTTP_ENV{'User-Agent'} =~ /Windows\s*3\.1/ ){
	return('false');
    }else{
	return('true');
    }
}
1;
