package mtime;
# ShellFire -- ObjectiveShell on httpd
# (C) KUBO Hiroya(hiroya@sfc.keio.ac.jp)
#
#############################################################################
# 
# ǯɽӤơᤤ٤Ӥ򤹤뤿ΥѥåǤ
# 
# perltimelocalؿˤϥХꡢ̵¥롼פ˴٤Ȥǰޤ
# ʤΤǡlocaltime/timelocal ΤΤ뤳Ȥˤޤ
#
# Ūˤϡmesurable time(mtime) ȤǯɽŪѤޤ
#
# 1997/06/22 Hiroya KUBO (hiroya@sfc.keio.ac.jp)

# ܵǽ
# դmeasurable time롣
# Ȥ1999ǯ131ξ硢$mtime=&date2mtime(1999,1,31) ȤѤ롣
sub date2mtime{
    my($year,$mon,$mday)=@_;
    return ( $mday+$mon*100+$year*10000 );
}

# ߤlocaltimemeasurable time롣
# $mtime=&now2mtime()
sub now2mtime{
     my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)
	 = localtime(time);
     return(&date2mtime(1900+$year,$mon+1,$mday));
}

# measurable timeդɽ3Ĥο֤
# 1999ǯ131ξ硢(1999,1,31)=&mtime2date() ȤѤ롣
sub mtime2date{
    my($mtime)=@_;
    my( $year , $mon, $mday );
    $mday =  $mtime%100;
    $mon  = ($mtime-$mday)%10000/100;
    $year = ($mtime-$mday-$mon*100)/10000;
    return ( $year , $mon, $mday );
}

# measurable time"yyyy/mm/dd"ȤʸѴ
sub mtime2char{
    my($mtime)=@_;
    return (sprintf '%4d/%02d/%02d', &mtime2date($mtime));
}

# "yyyy/mm/dd"Ȥʸmeasurable timeѴ
sub char2mtime{
    my($char)=@_;
    if($char ne ''){
	my($year,$mon,$mday)=split('/',$char);
	return(&date2mtime($year,$mon,$mday));
    }else{
	return(-1);
    }
}

sub mtime2GMTstring{
    my($mtime)=@_;
    my($yyyy,$mm,$dd)=&mtime2date($mtime);

    return (sprintf "%s, %02d %3s %4d %02d:%02d:%02d GMT"
	,('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[0]
        ,$dd
	,('','Jan','Feb','Mar','Apr','May','Jun',
	  'Jul','Aug','Sep','Oct','Nov','Dec')[$mm]
	,$yyyy
	,0,0,0);
}

sub GMT{
    my($time)=@_;
    my(@gmtime);
    if(defined($time) && $time ne ''){
	@gmtime=gmtime($time);
    }else{
	@gmtime=gmtime();
    }

    return (sprintf "%s, %02d %3s %4d %02d:%02d:%02d GMT"
	,('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$gmtime[6]]
        ,$gmtime[3]
	,('Jan','Feb','Mar','Apr','May','Jun',
	  'Jul','Aug','Sep','Oct','Nov','Dec')[$gmtime[4]]
	,$gmtime[5]+1900
	,$gmtime[2],$gmtime[1],$gmtime[0]);
}
sub JST{
    my($time)=@_;
    my(@ltime);
    if($time ne ''){
	@ltime=localtime($time);
    }else{
	@ltime=localtime();
    }

    return (sprintf "%s, %02d %3s %4d %02d:%02d:%02d JST"
	,('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$ltime[6]]
        ,$ltime[3]
	,('Jan','Feb','Mar','Apr','May','Jun',
	  'Jul','Aug','Sep','Oct','Nov','Dec')[$ltime[4]]
	,$ltime[5]+1900
	,$ltime[2],$ltime[1],$ltime[0]);
}
sub JSTstringDayOnly{
    my($time)=@_;
    my(@ltime);
    if($time ne ''){
	@ltime=localtime($time);
    }else{
	@ltime=localtime();
    }
    return (sprintf "%4dǯ%02d%02d(%s)"
	,$ltime[5]+1900
	,$ltime[4]+1
        ,$ltime[3]
	,('','','','','','','')[$ltime[6]]);
}
sub JSTstring{
    my($time)=@_;
    my(@ltime);
    if($time ne ''){
	@ltime=localtime($time);
    }else{
	@ltime=localtime();
    }
    return (sprintf "%4dǯ%02d%02d(%s) %02d:%02d:%02d"
	,$ltime[5]+1900
	,$ltime[4]+1
        ,$ltime[3]
        ,('','','','','','','')[$ltime[6]]
        ,$ltime[2]
        ,$ltime[1]
	,$ltime[0]
	    );
}

sub JSTlogstr{
    my($time)=@_;
    my(@ltime);
    if($time ne ''){
	@ltime=localtime($time);
    }else{
	@ltime=localtime();
    }

    return (sprintf "%02d/%3s/%4d:%02d:%02d:%02d +0900"
        ,$ltime[3]
	,('Jan','Feb','Mar','Apr','May','Jun',
	  'Jul','Aug','Sep','Oct','Nov','Dec')[$ltime[4]]
	,$ltime[5]+1900
	,$ltime[2],$ltime[1],$ltime[0]);
}
sub cookieGMT{
    my($time)=@_;
    my(@gmtime);
    if($time ne ''){
	@gmtime=gmtime($time);
    }else{
	@gmtime=gmtime();
    }

    return (sprintf "%s, %02d-%3s-%4d %02d:%02d:%02d GMT"
	,('Sunday','Monday','Tuesday','Wednesday',
	  'Thursday','Friday','Satday')[$gmtime[6]]
        ,$gmtime[3]
	,('Jan','Feb','Mar','Apr','May','Jun',
	  'Jul','Aug','Sep','Oct','Nov','Dec')[$gmtime[4]]
	,$gmtime[5]+1900
	,$gmtime[2],$gmtime[1],$gmtime[0]);
}

#############################################################################
# βû

# "yyyy/mm/dd"դˡXä "yyyy/mm/dd"֤
sub chardatePlusmday{
    my($datechar,$Plusmday)=@_;

    &mtime2char(&mtimePlusmday(
	&char2mtime($datechar)
   ,$Plusmday )
   );
}

# "yyyy/mm/dd"դˡXä "yyyy/mm/dd"֤
sub chardatePlusmon{
    my($datechar,$Plusmon)=@_;

    &mtime2char(&mtimePlusmon(
	&char2mtime($datechar)
   ,$Plusmon )
   );
}

# measurable timeˡXä롣
# $PlusedMtime = mtimePlusmday($mtime,$X);
sub mtimePlusmday{
    my($mtime,$Plusmday)=@_;
    &date2mtime(&datePlusmday(&mtime2date($mtime),$Plusmday));
}

# measurable timeˡXä롣
# $PlusedMtime = mtimePlusmon($mtime,$X);
sub mtimePlusmon{
    my($mtime,$Plusmon)=@_;
    &date2mtime(&datePlusmon(&mtime2date($mtime),$Plusmon));
}

# dateˡXä롣
sub datePlusmday{
    my($year,$mon,$mday,$Plusmday)=@_;
    @days=(0, 31,28,31,30,31,30,31,31,30,31,30,31);
    my($Year,$Mon,$Mday)=($year,$mon,$mday);
    for($Mday+=$Plusmday; $Mday>$days[$Mon];){
	if($Year%4==0 && $Mon==2 && $Mday>29){
	    $Mday-=29;
	    $Mon++; 
	}
	elsif($Mday>$days[$Mon] ){
	    $Mday-=$days[$Mon];
	    $Mon++; 
	}
	if($Mon>12){
	    $Year++;
	    $Mon=1;
	}
    }
    return ( $Year , $Mon, $Mday );
}

# dateˡXä롣
sub datePlusmon{
    my($year,$mon,$mday,$Plusmon)=@_;
    @days=(0, 31,28,31,30,31,30,31,31,30,31,30,31);
    my($Year,$Mon,$Mday)=($year,$mon,$mday);
    for($Mon+=$Plusmon; $Mday>$days[$Mon]||$Mon>12;){
	if($Mon>12 ){
	    $Mon-=12;
	    $Year++; 
	}
	if($Mday>$days[$Mon] ){
	    $Mday-=$days[$Mon];
	    $Mon++; 
	}
    }
    return ( $Year , $Mon, $Mday );
}

1;


